@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Suppress

/**
 * Scope of the extension. It can be either Cluster or Namespace; but not both.
 * @property cluster Specifies that the scope of the extension is Cluster
 * @property namespace Specifies that the scope of the extension is Namespace
 */
public data class ScopeResponse(
    public val cluster: ScopeClusterResponse? = null,
    public val namespace: ScopeNamespaceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.ScopeResponse): ScopeResponse = ScopeResponse(
            cluster = javaType.cluster().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ScopeClusterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            namespace = javaType.namespace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ScopeNamespaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
