@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
 * @property kind Define whether it is ConfigMap or Secret that holds the variables to be used in substitution.
 * @property name Name of the ConfigMap/Secret that holds the variables to be used in substitution.
 * @property optional Set to True to proceed without ConfigMap/Secret, if it is not present.
 */
public data class SubstituteFromDefinitionResponse(
    public val kind: String? = null,
    public val name: String? = null,
    public val optional: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.SubstituteFromDefinitionResponse): SubstituteFromDefinitionResponse = SubstituteFromDefinitionResponse(
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            optional = javaType.optional().map({ args0 -> args0 }).orElse(null),
        )
    }
}
