@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin

import com.pulumi.azurenative.kubernetesruntime.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.kubernetesruntime.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BgpPeer].
 */
@PulumiTagMarker
public class BgpPeerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BgpPeerArgs = BgpPeerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BgpPeerArgsBuilder.() -> Unit) {
        val builder = BgpPeerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BgpPeer {
        val builtJavaResource =
            com.pulumi.azurenative.kubernetesruntime.BgpPeer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BgpPeer(builtJavaResource)
    }
}

/**
 * A BgpPeer resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters)
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### BgpPeers_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bgpPeer = new AzureNative.KubernetesRuntime.BgpPeer("bgpPeer", new()
 *     {
 *         BgpPeerName = "testpeer",
 *         MyAsn = 64500,
 *         PeerAddress = "10.0.0.1",
 *         PeerAsn = 64501,
 *         ResourceUri = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesruntime/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesruntime.NewBgpPeer(ctx, "bgpPeer", &kubernetesruntime.BgpPeerArgs{
 * 			BgpPeerName: pulumi.String("testpeer"),
 * 			MyAsn:       pulumi.Int(64500),
 * 			PeerAddress: pulumi.String("10.0.0.1"),
 * 			PeerAsn:     pulumi.Int(64501),
 * 			ResourceUri: pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesruntime.BgpPeer;
 * import com.pulumi.azurenative.kubernetesruntime.BgpPeerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bgpPeer = new BgpPeer("bgpPeer", BgpPeerArgs.builder()
 *             .bgpPeerName("testpeer")
 *             .myAsn(64500)
 *             .peerAddress("10.0.0.1")
 *             .peerAsn(64501)
 *             .resourceUri("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesruntime:BgpPeer testpeer /{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}
 * ```
 */
public class BgpPeer internal constructor(
    override val javaResource: com.pulumi.azurenative.kubernetesruntime.BgpPeer,
) : KotlinCustomResource(javaResource, BgpPeerMapper) {
    /**
     * My ASN
     */
    public val myAsn: Output<Int>
        get() = javaResource.myAsn().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Peer Address
     */
    public val peerAddress: Output<String>
        get() = javaResource.peerAddress().applyValue({ args0 -> args0 })

    /**
     * Peer ASN
     */
    public val peerAsn: Output<Int>
        get() = javaResource.peerAsn().applyValue({ args0 -> args0 })

    /**
     * Resource provision state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BgpPeerMapper : ResourceMapper<BgpPeer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kubernetesruntime.BgpPeer::class == javaResource::class

    override fun map(javaResource: Resource): BgpPeer = BgpPeer(
        javaResource as
            com.pulumi.azurenative.kubernetesruntime.BgpPeer,
    )
}

/**
 * @see [BgpPeer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BgpPeer].
 */
public suspend fun bgpPeer(name: String, block: suspend BgpPeerResourceBuilder.() -> Unit): BgpPeer {
    val builder = BgpPeerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BgpPeer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bgpPeer(name: String): BgpPeer {
    val builder = BgpPeerResourceBuilder()
    builder.name(name)
    return builder.build()
}
