@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin

import com.pulumi.azurenative.kubernetesruntime.BgpPeerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A BgpPeer resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters)
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### BgpPeers_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bgpPeer = new AzureNative.KubernetesRuntime.BgpPeer("bgpPeer", new()
 *     {
 *         BgpPeerName = "testpeer",
 *         MyAsn = 64500,
 *         PeerAddress = "10.0.0.1",
 *         PeerAsn = 64501,
 *         ResourceUri = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesruntime/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesruntime.NewBgpPeer(ctx, "bgpPeer", &kubernetesruntime.BgpPeerArgs{
 * 			BgpPeerName: pulumi.String("testpeer"),
 * 			MyAsn:       pulumi.Int(64500),
 * 			PeerAddress: pulumi.String("10.0.0.1"),
 * 			PeerAsn:     pulumi.Int(64501),
 * 			ResourceUri: pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesruntime.BgpPeer;
 * import com.pulumi.azurenative.kubernetesruntime.BgpPeerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bgpPeer = new BgpPeer("bgpPeer", BgpPeerArgs.builder()
 *             .bgpPeerName("testpeer")
 *             .myAsn(64500)
 *             .peerAddress("10.0.0.1")
 *             .peerAsn(64501)
 *             .resourceUri("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesruntime:BgpPeer testpeer /{resourceUri}/providers/Microsoft.KubernetesRuntime/bgpPeers/{bgpPeerName}
 * ```
 * @property bgpPeerName The name of the BgpPeer
 * @property myAsn My ASN
 * @property peerAddress Peer Address
 * @property peerAsn Peer ASN
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource.
 */
public data class BgpPeerArgs(
    public val bgpPeerName: Output<String>? = null,
    public val myAsn: Output<Int>? = null,
    public val peerAddress: Output<String>? = null,
    public val peerAsn: Output<Int>? = null,
    public val resourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.BgpPeerArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.BgpPeerArgs =
        com.pulumi.azurenative.kubernetesruntime.BgpPeerArgs.builder()
            .bgpPeerName(bgpPeerName?.applyValue({ args0 -> args0 }))
            .myAsn(myAsn?.applyValue({ args0 -> args0 }))
            .peerAddress(peerAddress?.applyValue({ args0 -> args0 }))
            .peerAsn(peerAsn?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpPeerArgs].
 */
@PulumiTagMarker
public class BgpPeerArgsBuilder internal constructor() {
    private var bgpPeerName: Output<String>? = null

    private var myAsn: Output<Int>? = null

    private var peerAddress: Output<String>? = null

    private var peerAsn: Output<Int>? = null

    private var resourceUri: Output<String>? = null

    /**
     * @param value The name of the BgpPeer
     */
    @JvmName("gdmrtkfrhoadmago")
    public suspend fun bgpPeerName(`value`: Output<String>) {
        this.bgpPeerName = value
    }

    /**
     * @param value My ASN
     */
    @JvmName("fqhtdjsqifirlcxh")
    public suspend fun myAsn(`value`: Output<Int>) {
        this.myAsn = value
    }

    /**
     * @param value Peer Address
     */
    @JvmName("orcuyqcdayqlsbjl")
    public suspend fun peerAddress(`value`: Output<String>) {
        this.peerAddress = value
    }

    /**
     * @param value Peer ASN
     */
    @JvmName("hidscprtwoanrkhq")
    public suspend fun peerAsn(`value`: Output<Int>) {
        this.peerAsn = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("yppshfnakphbtolp")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value The name of the BgpPeer
     */
    @JvmName("lmqtcwfcwevevpxw")
    public suspend fun bgpPeerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpPeerName = mapped
    }

    /**
     * @param value My ASN
     */
    @JvmName("vuapumvlijbyincu")
    public suspend fun myAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.myAsn = mapped
    }

    /**
     * @param value Peer Address
     */
    @JvmName("rjntmhgfvsuakfgs")
    public suspend fun peerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAddress = mapped
    }

    /**
     * @param value Peer ASN
     */
    @JvmName("wgjaushvtrgopbhr")
    public suspend fun peerAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAsn = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("lqwmtowrdawnurdr")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    internal fun build(): BgpPeerArgs = BgpPeerArgs(
        bgpPeerName = bgpPeerName,
        myAsn = myAsn,
        peerAddress = peerAddress,
        peerAsn = peerAsn,
        resourceUri = resourceUri,
    )
}
