@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin

import com.pulumi.azurenative.kubernetesruntime.ServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A Service resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters)
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### Services_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.KubernetesRuntime.Service("service", new()
 *     {
 *         ResourceUri = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1",
 *         ServiceName = "storageclass",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesruntime/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesruntime.NewService(ctx, "service", &kubernetesruntime.ServiceArgs{
 * 			ResourceUri: pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1"),
 * 			ServiceName: pulumi.String("storageclass"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesruntime.Service;
 * import com.pulumi.azurenative.kubernetesruntime.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .resourceUri("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/example/providers/Microsoft.Kubernetes/connectedClusters/cluster1")
 *             .serviceName("storageclass")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesruntime:Service storageclass /{resourceUri}/providers/Microsoft.KubernetesRuntime/services/{serviceName}
 * ```
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource.
 * @property serviceName The name of the the service
 */
public data class ServiceArgs(
    public val resourceUri: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.ServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.ServiceArgs =
        com.pulumi.azurenative.kubernetesruntime.ServiceArgs.builder()
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var resourceUri: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("erpjcviboaeijgbo")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value The name of the the service
     */
    @JvmName("gursujbgyhcsctld")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("catrpavtvkqrsxnp")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value The name of the the service
     */
    @JvmName("fmoiexjafwjbqgbv")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        resourceUri = resourceUri,
        serviceName = serviceName,
    )
}
