@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Failover speed: NA, Slow, Fast
 */
public enum class FailoverTier(
    public val javaValue: com.pulumi.azurenative.kubernetesruntime.enums.FailoverTier,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.enums.FailoverTier> {
    /**
     * Not available Failover Tier
     */
    NotAvailable(com.pulumi.azurenative.kubernetesruntime.enums.FailoverTier.NotAvailable),

    /**
     * Slow Failover Tier
     */
    Slow(com.pulumi.azurenative.kubernetesruntime.enums.FailoverTier.Slow),

    /**
     * Fast Failover Tier
     */
    Fast(com.pulumi.azurenative.kubernetesruntime.enums.FailoverTier.Fast),

    /**
     * Super Failover Tier
     */
    Super(com.pulumi.azurenative.kubernetesruntime.enums.FailoverTier.Super),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.enums.FailoverTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.enums.FailoverTier): FailoverTier = FailoverTier.values().first { it.javaValue == javaType }
    }
}
