@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The action to take when a NFS volume is deleted. Default is Delete
 */
public enum class NfsDirectoryActionOnVolumeDeletion(
    public val javaValue: com.pulumi.azurenative.kubernetesruntime.enums.NfsDirectoryActionOnVolumeDeletion,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.enums.NfsDirectoryActionOnVolumeDeletion> {
    /**
     * When the volume is deleted, delete the directory
     */
    Delete(com.pulumi.azurenative.kubernetesruntime.enums.NfsDirectoryActionOnVolumeDeletion.Delete),

    /**
     * When the volume is deleted, retain the directory
     */
    Retain(com.pulumi.azurenative.kubernetesruntime.enums.NfsDirectoryActionOnVolumeDeletion.Retain),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.enums.NfsDirectoryActionOnVolumeDeletion = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.enums.NfsDirectoryActionOnVolumeDeletion): NfsDirectoryActionOnVolumeDeletion =
            NfsDirectoryActionOnVolumeDeletion.values().first { it.javaValue == javaType }
    }
}
