@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Binding mode of volumes: Immediate, WaitForFirstConsumer
 */
public enum class VolumeBindingMode(
    public val javaValue: com.pulumi.azurenative.kubernetesruntime.enums.VolumeBindingMode,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.enums.VolumeBindingMode> {
    /**
     * Immediate binding mode
     */
    Immediate(com.pulumi.azurenative.kubernetesruntime.enums.VolumeBindingMode.Immediate),

    /**
     * Wait for first consumer binding mode
     */
    WaitForFirstConsumer(com.pulumi.azurenative.kubernetesruntime.enums.VolumeBindingMode.WaitForFirstConsumer),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.enums.VolumeBindingMode =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.enums.VolumeBindingMode): VolumeBindingMode = VolumeBindingMode.values().first { it.javaValue == javaType }
    }
}
