@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Volume can be expanded or not
 */
public enum class VolumeExpansion(
    public val javaValue: com.pulumi.azurenative.kubernetesruntime.enums.VolumeExpansion,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.enums.VolumeExpansion> {
    /**
     * Allow volume expansion
     */
    Allow(com.pulumi.azurenative.kubernetesruntime.enums.VolumeExpansion.Allow),

    /**
     * Disallow volume expansion
     */
    Disallow(com.pulumi.azurenative.kubernetesruntime.enums.VolumeExpansion.Disallow),
    ;

    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.enums.VolumeExpansion = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.enums.VolumeExpansion): VolumeExpansion = VolumeExpansion.values().first { it.javaValue == javaType }
    }
}
