@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.inputs

import com.pulumi.azurenative.kubernetesruntime.inputs.BlobStorageClassTypePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of Blob StorageClass
 * @property azureStorageAccountKey Azure Storage Account Key
 * @property azureStorageAccountName Azure Storage Account Name
 * @property type Type of a storage class
 * Expected value is 'Blob'.
 */
public data class BlobStorageClassTypePropertiesArgs(
    public val azureStorageAccountKey: Output<String>,
    public val azureStorageAccountName: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.inputs.BlobStorageClassTypePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.inputs.BlobStorageClassTypePropertiesArgs =
        com.pulumi.azurenative.kubernetesruntime.inputs.BlobStorageClassTypePropertiesArgs.builder()
            .azureStorageAccountKey(azureStorageAccountKey.applyValue({ args0 -> args0 }))
            .azureStorageAccountName(azureStorageAccountName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobStorageClassTypePropertiesArgs].
 */
@PulumiTagMarker
public class BlobStorageClassTypePropertiesArgsBuilder internal constructor() {
    private var azureStorageAccountKey: Output<String>? = null

    private var azureStorageAccountName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Azure Storage Account Key
     */
    @JvmName("oljocamyscfcjbea")
    public suspend fun azureStorageAccountKey(`value`: Output<String>) {
        this.azureStorageAccountKey = value
    }

    /**
     * @param value Azure Storage Account Name
     */
    @JvmName("kegfttetkwfdivek")
    public suspend fun azureStorageAccountName(`value`: Output<String>) {
        this.azureStorageAccountName = value
    }

    /**
     * @param value Type of a storage class
     * Expected value is 'Blob'.
     */
    @JvmName("lmkpnhosogfpkrne")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Azure Storage Account Key
     */
    @JvmName("ktkyixoelvigjgqr")
    public suspend fun azureStorageAccountKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureStorageAccountKey = mapped
    }

    /**
     * @param value Azure Storage Account Name
     */
    @JvmName("bfjaykmedaxkoshy")
    public suspend fun azureStorageAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureStorageAccountName = mapped
    }

    /**
     * @param value Type of a storage class
     * Expected value is 'Blob'.
     */
    @JvmName("wmlxqqgvtqrrngvb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BlobStorageClassTypePropertiesArgs = BlobStorageClassTypePropertiesArgs(
        azureStorageAccountKey = azureStorageAccountKey ?: throw
            PulumiNullFieldException("azureStorageAccountKey"),
        azureStorageAccountName = azureStorageAccountName ?: throw
            PulumiNullFieldException("azureStorageAccountName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
