@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.inputs

import com.pulumi.azurenative.kubernetesruntime.inputs.GetBgpPeerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bgpPeerName The name of the BgpPeer
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource.
 */
public data class GetBgpPeerPlainArgs(
    public val bgpPeerName: String,
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.inputs.GetBgpPeerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.inputs.GetBgpPeerPlainArgs =
        com.pulumi.azurenative.kubernetesruntime.inputs.GetBgpPeerPlainArgs.builder()
            .bgpPeerName(bgpPeerName.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBgpPeerPlainArgs].
 */
@PulumiTagMarker
public class GetBgpPeerPlainArgsBuilder internal constructor() {
    private var bgpPeerName: String? = null

    private var resourceUri: String? = null

    /**
     * @param value The name of the BgpPeer
     */
    @JvmName("cdxsxnjwvgxcsadh")
    public suspend fun bgpPeerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bgpPeerName = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("ytjxqsigkflkqwoc")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetBgpPeerPlainArgs = GetBgpPeerPlainArgs(
        bgpPeerName = bgpPeerName ?: throw PulumiNullFieldException("bgpPeerName"),
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
