@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.inputs

import com.pulumi.azurenative.kubernetesruntime.inputs.GetLoadBalancerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property loadBalancerName The name of the LoadBalancer
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource.
 */
public data class GetLoadBalancerPlainArgs(
    public val loadBalancerName: String,
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.inputs.GetLoadBalancerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.inputs.GetLoadBalancerPlainArgs =
        com.pulumi.azurenative.kubernetesruntime.inputs.GetLoadBalancerPlainArgs.builder()
            .loadBalancerName(loadBalancerName.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLoadBalancerPlainArgs].
 */
@PulumiTagMarker
public class GetLoadBalancerPlainArgsBuilder internal constructor() {
    private var loadBalancerName: String? = null

    private var resourceUri: String? = null

    /**
     * @param value The name of the LoadBalancer
     */
    @JvmName("tbsqcaxwdxtiqtvu")
    public suspend fun loadBalancerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("njmbrhjwjnjhacbk")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetLoadBalancerPlainArgs = GetLoadBalancerPlainArgs(
        loadBalancerName = loadBalancerName ?: throw PulumiNullFieldException("loadBalancerName"),
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
