@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.inputs

import com.pulumi.azurenative.kubernetesruntime.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource.
 * @property serviceName The name of the the service
 */
public data class GetServicePlainArgs(
    public val resourceUri: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.inputs.GetServicePlainArgs =
        com.pulumi.azurenative.kubernetesruntime.inputs.GetServicePlainArgs.builder()
            .resourceUri(resourceUri.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var resourceUri: String? = null

    private var serviceName: String? = null

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("ryastqkhqbahiqhk")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    /**
     * @param value The name of the the service
     */
    @JvmName("magpbvhegfubmtyv")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
