@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.inputs

import com.pulumi.azurenative.kubernetesruntime.inputs.NfsStorageClassTypePropertiesArgs.builder
import com.pulumi.azurenative.kubernetesruntime.kotlin.enums.NfsDirectoryActionOnVolumeDeletion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of NFS StorageClass
 * @property mountPermissions Mounted folder permissions. Default is 0. If set as non-zero, driver will perform `chmod` after mount
 * @property onDelete The action to take when a NFS volume is deleted. Default is Delete
 * @property server NFS Server
 * @property share NFS share
 * @property subDir Sub directory under share. If the sub directory doesn't exist, driver will create it
 * @property type Type of a storage class
 * Expected value is 'NFS'.
 */
public data class NfsStorageClassTypePropertiesArgs(
    public val mountPermissions: Output<String>? = null,
    public val onDelete: Output<Either<String, NfsDirectoryActionOnVolumeDeletion>>? = null,
    public val server: Output<String>,
    public val share: Output<String>,
    public val subDir: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.inputs.NfsStorageClassTypePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.inputs.NfsStorageClassTypePropertiesArgs =
        com.pulumi.azurenative.kubernetesruntime.inputs.NfsStorageClassTypePropertiesArgs.builder()
            .mountPermissions(mountPermissions?.applyValue({ args0 -> args0 }))
            .onDelete(
                onDelete?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .server(server.applyValue({ args0 -> args0 }))
            .share(share.applyValue({ args0 -> args0 }))
            .subDir(subDir?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NfsStorageClassTypePropertiesArgs].
 */
@PulumiTagMarker
public class NfsStorageClassTypePropertiesArgsBuilder internal constructor() {
    private var mountPermissions: Output<String>? = null

    private var onDelete: Output<Either<String, NfsDirectoryActionOnVolumeDeletion>>? = null

    private var server: Output<String>? = null

    private var share: Output<String>? = null

    private var subDir: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Mounted folder permissions. Default is 0. If set as non-zero, driver will perform `chmod` after mount
     */
    @JvmName("pjqwqqtikydroyan")
    public suspend fun mountPermissions(`value`: Output<String>) {
        this.mountPermissions = value
    }

    /**
     * @param value The action to take when a NFS volume is deleted. Default is Delete
     */
    @JvmName("lydhfwpfxtygytul")
    public suspend fun onDelete(`value`: Output<Either<String, NfsDirectoryActionOnVolumeDeletion>>) {
        this.onDelete = value
    }

    /**
     * @param value NFS Server
     */
    @JvmName("bcekbgppccahebyf")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value NFS share
     */
    @JvmName("kvgvgxsxlyjjjwso")
    public suspend fun share(`value`: Output<String>) {
        this.share = value
    }

    /**
     * @param value Sub directory under share. If the sub directory doesn't exist, driver will create it
     */
    @JvmName("xiujpgdfduvbttyl")
    public suspend fun subDir(`value`: Output<String>) {
        this.subDir = value
    }

    /**
     * @param value Type of a storage class
     * Expected value is 'NFS'.
     */
    @JvmName("rwpecvvdmpyunoni")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Mounted folder permissions. Default is 0. If set as non-zero, driver will perform `chmod` after mount
     */
    @JvmName("htsowobewdtraapy")
    public suspend fun mountPermissions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPermissions = mapped
    }

    /**
     * @param value The action to take when a NFS volume is deleted. Default is Delete
     */
    @JvmName("mgscpnsfhvdabufq")
    public suspend fun onDelete(`value`: Either<String, NfsDirectoryActionOnVolumeDeletion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDelete = mapped
    }

    /**
     * @param value The action to take when a NFS volume is deleted. Default is Delete
     */
    @JvmName("stbxtcbqeoydmqou")
    public fun onDelete(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NfsDirectoryActionOnVolumeDeletion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onDelete = mapped
    }

    /**
     * @param value The action to take when a NFS volume is deleted. Default is Delete
     */
    @JvmName("xdmywppkoeksrafx")
    public fun onDelete(`value`: NfsDirectoryActionOnVolumeDeletion) {
        val toBeMapped = Either.ofRight<String, NfsDirectoryActionOnVolumeDeletion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onDelete = mapped
    }

    /**
     * @param value NFS Server
     */
    @JvmName("qnpdhdqoeluiydsf")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value NFS share
     */
    @JvmName("ktkvheptowpibrgp")
    public suspend fun share(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.share = mapped
    }

    /**
     * @param value Sub directory under share. If the sub directory doesn't exist, driver will create it
     */
    @JvmName("vkdjvqjnqavgcgjd")
    public suspend fun subDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subDir = mapped
    }

    /**
     * @param value Type of a storage class
     * Expected value is 'NFS'.
     */
    @JvmName("etbgbyposuywqacb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): NfsStorageClassTypePropertiesArgs = NfsStorageClassTypePropertiesArgs(
        mountPermissions = mountPermissions,
        onDelete = onDelete,
        server = server ?: throw PulumiNullFieldException("server"),
        share = share ?: throw PulumiNullFieldException("share"),
        subDir = subDir,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
