@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.inputs

import com.pulumi.azurenative.kubernetesruntime.inputs.SmbStorageClassTypePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of SMB StorageClass
 * @property domain Server domain
 * @property password Server password
 * @property source SMB Source
 * @property subDir Sub directory under share. If the sub directory doesn't exist, driver will create it
 * @property type Type of a storage class
 * Expected value is 'SMB'.
 * @property username Server username
 */
public data class SmbStorageClassTypePropertiesArgs(
    public val domain: Output<String>? = null,
    public val password: Output<String>? = null,
    public val source: Output<String>,
    public val subDir: Output<String>? = null,
    public val type: Output<String>,
    public val username: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesruntime.inputs.SmbStorageClassTypePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesruntime.inputs.SmbStorageClassTypePropertiesArgs =
        com.pulumi.azurenative.kubernetesruntime.inputs.SmbStorageClassTypePropertiesArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .source(source.applyValue({ args0 -> args0 }))
            .subDir(subDir?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SmbStorageClassTypePropertiesArgs].
 */
@PulumiTagMarker
public class SmbStorageClassTypePropertiesArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var password: Output<String>? = null

    private var source: Output<String>? = null

    private var subDir: Output<String>? = null

    private var type: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Server domain
     */
    @JvmName("gqpcwkbjsbgkqskw")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value Server password
     */
    @JvmName("qltmcrnkakijuume")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value SMB Source
     */
    @JvmName("wgkuknodxcgwytbk")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Sub directory under share. If the sub directory doesn't exist, driver will create it
     */
    @JvmName("mqbivmkiypqxowvn")
    public suspend fun subDir(`value`: Output<String>) {
        this.subDir = value
    }

    /**
     * @param value Type of a storage class
     * Expected value is 'SMB'.
     */
    @JvmName("qnxlwfyqqeyehwam")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Server username
     */
    @JvmName("efgjrgmaoeelqeqq")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Server domain
     */
    @JvmName("ewqtglsmpyndtxdo")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Server password
     */
    @JvmName("ytafmjeghkshwool")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value SMB Source
     */
    @JvmName("gdknqvqrkdlyhniy")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Sub directory under share. If the sub directory doesn't exist, driver will create it
     */
    @JvmName("vnxyofnkbmexbcju")
    public suspend fun subDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subDir = mapped
    }

    /**
     * @param value Type of a storage class
     * Expected value is 'SMB'.
     */
    @JvmName("phiaucjmsfjkhxak")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Server username
     */
    @JvmName("brtmiuvcbtdnbhhf")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): SmbStorageClassTypePropertiesArgs = SmbStorageClassTypePropertiesArgs(
        domain = domain,
        password = password,
        source = source ?: throw PulumiNullFieldException("source"),
        subDir = subDir,
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
