@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of Blob StorageClass
 * @property azureStorageAccountKey Azure Storage Account Key
 * @property azureStorageAccountName Azure Storage Account Name
 * @property type Type of a storage class
 * Expected value is 'Blob'.
 */
public data class BlobStorageClassTypePropertiesResponse(
    public val azureStorageAccountKey: String,
    public val azureStorageAccountName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.outputs.BlobStorageClassTypePropertiesResponse): BlobStorageClassTypePropertiesResponse = BlobStorageClassTypePropertiesResponse(
            azureStorageAccountKey = javaType.azureStorageAccountKey(),
            azureStorageAccountName = javaType.azureStorageAccountName(),
            type = javaType.type(),
        )
    }
}
