@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A LoadBalancer resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters)
 * @property addresses IP Range
 * @property advertiseMode Advertise Mode
 * @property bgpPeers The list of BGP peers it should advertise to. Null or empty means to advertise to all peers.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property provisioningState Resource provision state
 * @property serviceSelector A dynamic label mapping to select related services. For instance, if you want to create a load balancer only for services with label "a=b", then please specify {"a": "b"} in the field.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLoadBalancerResult(
    public val addresses: List<String>,
    public val advertiseMode: String,
    public val bgpPeers: List<String>? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val serviceSelector: Map<String, String>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.outputs.GetLoadBalancerResult): GetLoadBalancerResult = GetLoadBalancerResult(
            addresses = javaType.addresses().map({ args0 -> args0 }),
            advertiseMode = javaType.advertiseMode(),
            bgpPeers = javaType.bgpPeers().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            serviceSelector = javaType.serviceSelector().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.kubernetesruntime.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
