@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.outputs

import kotlin.Any
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A StorageClass resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters)
 * @property accessModes The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce]
 * @property allowVolumeExpansion Volume can be expanded or not
 * @property dataResilience Allow single data node failure
 * @property failoverSpeed Failover speed: NA, Slow, Fast
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property limitations Limitations of the storage class
 * @property mountOptions Additional mount options
 * @property name The name of the resource
 * @property performance Performance tier
 * @property priority Selection priority when multiple storage classes meet the criteria. 0: Highest, -1: Never use
 * @property provisioner Provisioner name
 * @property provisioningState Resource provision state
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property typeProperties Properties of the StorageClass
 * @property volumeBindingMode Binding mode of volumes: Immediate, WaitForFirstConsumer
 */
public data class GetStorageClassResult(
    public val accessModes: List<String>? = null,
    public val allowVolumeExpansion: String? = null,
    public val dataResilience: String? = null,
    public val failoverSpeed: String? = null,
    public val id: String,
    public val limitations: List<String>? = null,
    public val mountOptions: List<String>? = null,
    public val name: String,
    public val performance: String? = null,
    public val priority: Double? = null,
    public val provisioner: String? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val typeProperties: Any,
    public val volumeBindingMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.outputs.GetStorageClassResult): GetStorageClassResult = GetStorageClassResult(
            accessModes = javaType.accessModes().map({ args0 -> args0 }),
            allowVolumeExpansion = javaType.allowVolumeExpansion().map({ args0 -> args0 }).orElse(null),
            dataResilience = javaType.dataResilience().map({ args0 -> args0 }).orElse(null),
            failoverSpeed = javaType.failoverSpeed().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            limitations = javaType.limitations().map({ args0 -> args0 }),
            mountOptions = javaType.mountOptions().map({ args0 -> args0 }),
            name = javaType.name(),
            performance = javaType.performance().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            provisioner = javaType.provisioner().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.kubernetesruntime.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            typeProperties = javaType.typeProperties(),
            volumeBindingMode = javaType.volumeBindingMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
