@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of RWX StorageClass
 * @property backingStorageClassName The backing storageclass used to create new storageclass
 * @property type Type of a storage class
 * Expected value is 'RWX'.
 */
public data class RwxStorageClassTypePropertiesResponse(
    public val backingStorageClassName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.outputs.RwxStorageClassTypePropertiesResponse): RwxStorageClassTypePropertiesResponse = RwxStorageClassTypePropertiesResponse(
            backingStorageClassName = javaType.backingStorageClassName(),
            type = javaType.type(),
        )
    }
}
