@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesruntime.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of SMB StorageClass
 * @property domain Server domain
 * @property password Server password
 * @property source SMB Source
 * @property subDir Sub directory under share. If the sub directory doesn't exist, driver will create it
 * @property type Type of a storage class
 * Expected value is 'SMB'.
 * @property username Server username
 */
public data class SmbStorageClassTypePropertiesResponse(
    public val domain: String? = null,
    public val password: String? = null,
    public val source: String,
    public val subDir: String? = null,
    public val type: String,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kubernetesruntime.outputs.SmbStorageClassTypePropertiesResponse): SmbStorageClassTypePropertiesResponse = SmbStorageClassTypePropertiesResponse(
            domain = javaType.domain().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            source = javaType.source(),
            subDir = javaType.subDir().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
