@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.CosmosDbDataConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a CosmosDb data connection.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### KustoDataConnectionsCosmosDbCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cosmosDbDataConnection = new AzureNative.Kusto.CosmosDbDataConnection("cosmosDbDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         CosmosDbAccountResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.DocumentDb/databaseAccounts/cosmosDbAccountTest1",
 *         CosmosDbContainer = "cosmosDbContainerTest",
 *         CosmosDbDatabase = "cosmosDbDatabaseTest",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase1",
 *         Kind = "CosmosDb",
 *         Location = "westus",
 *         ManagedIdentityResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1",
 *         MappingRuleName = "TestMapping",
 *         ResourceGroupName = "kustorptest",
 *         RetrievalStartDate = "2022-07-29T12:00:00.6554616Z",
 *         TableName = "TestTable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewCosmosDbDataConnection(ctx, "cosmosDbDataConnection", &kusto.CosmosDbDataConnectionArgs{
 * 			ClusterName:               pulumi.String("kustoCluster"),
 * 			CosmosDbAccountResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.DocumentDb/databaseAccounts/cosmosDbAccountTest1"),
 * 			CosmosDbContainer:         pulumi.String("cosmosDbContainerTest"),
 * 			CosmosDbDatabase:          pulumi.String("cosmosDbDatabaseTest"),
 * 			DataConnectionName:        pulumi.String("dataConnectionTest"),
 * 			DatabaseName:              pulumi.String("KustoDatabase1"),
 * 			Kind:                      pulumi.String("CosmosDb"),
 * 			Location:                  pulumi.String("westus"),
 * 			ManagedIdentityResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1"),
 * 			MappingRuleName:           pulumi.String("TestMapping"),
 * 			ResourceGroupName:         pulumi.String("kustorptest"),
 * 			RetrievalStartDate:        pulumi.String("2022-07-29T12:00:00.6554616Z"),
 * 			TableName:                 pulumi.String("TestTable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnection;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cosmosDbDataConnection = new CosmosDbDataConnection("cosmosDbDataConnection", CosmosDbDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .cosmosDbAccountResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.DocumentDb/databaseAccounts/cosmosDbAccountTest1")
 *             .cosmosDbContainer("cosmosDbContainerTest")
 *             .cosmosDbDatabase("cosmosDbDatabaseTest")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase1")
 *             .kind("CosmosDb")
 *             .location("westus")
 *             .managedIdentityResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1")
 *             .mappingRuleName("TestMapping")
 *             .resourceGroupName("kustorptest")
 *             .retrievalStartDate("2022-07-29T12:00:00.6554616Z")
 *             .tableName("TestTable")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cosmosDbDataConnection = new AzureNative.Kusto.CosmosDbDataConnection("cosmosDbDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewCosmosDbDataConnection(ctx, "cosmosDbDataConnection", &kusto.CosmosDbDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnection;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cosmosDbDataConnection = new CosmosDbDataConnection("cosmosDbDataConnection", CosmosDbDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsEventGridCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cosmosDbDataConnection = new AzureNative.Kusto.CosmosDbDataConnection("cosmosDbDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewCosmosDbDataConnection(ctx, "cosmosDbDataConnection", &kusto.CosmosDbDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnection;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cosmosDbDataConnection = new CosmosDbDataConnection("cosmosDbDataConnection", CosmosDbDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:CosmosDbDataConnection kustoCluster/KustoDatabase8/dataConnectionTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}
 * ```
 * @property clusterName The name of the Kusto cluster.
 * @property cosmosDbAccountResourceId The resource ID of the Cosmos DB account used to create the data connection.
 * @property cosmosDbContainer The name of an existing container in the Cosmos DB database.
 * @property cosmosDbDatabase The name of an existing database in the Cosmos DB account.
 * @property dataConnectionName The name of the data connection.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'CosmosDb'.
 * @property location Resource location.
 * @property managedIdentityResourceId The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB.
 * @property mappingRuleName The name of an existing mapping rule to use when ingesting the retrieved data.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 * @property retrievalStartDate Optional. If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date.
 * @property tableName The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table.
 */
public data class CosmosDbDataConnectionArgs(
    public val clusterName: Output<String>? = null,
    public val cosmosDbAccountResourceId: Output<String>? = null,
    public val cosmosDbContainer: Output<String>? = null,
    public val cosmosDbDatabase: Output<String>? = null,
    public val dataConnectionName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedIdentityResourceId: Output<String>? = null,
    public val mappingRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retrievalStartDate: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.CosmosDbDataConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.CosmosDbDataConnectionArgs =
        com.pulumi.azurenative.kusto.CosmosDbDataConnectionArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .cosmosDbAccountResourceId(cosmosDbAccountResourceId?.applyValue({ args0 -> args0 }))
            .cosmosDbContainer(cosmosDbContainer?.applyValue({ args0 -> args0 }))
            .cosmosDbDatabase(cosmosDbDatabase?.applyValue({ args0 -> args0 }))
            .dataConnectionName(dataConnectionName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedIdentityResourceId(managedIdentityResourceId?.applyValue({ args0 -> args0 }))
            .mappingRuleName(mappingRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retrievalStartDate(retrievalStartDate?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CosmosDbDataConnectionArgs].
 */
@PulumiTagMarker
public class CosmosDbDataConnectionArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var cosmosDbAccountResourceId: Output<String>? = null

    private var cosmosDbContainer: Output<String>? = null

    private var cosmosDbDatabase: Output<String>? = null

    private var dataConnectionName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var managedIdentityResourceId: Output<String>? = null

    private var mappingRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retrievalStartDate: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("elqwfnjyxtrfoamb")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The resource ID of the Cosmos DB account used to create the data connection.
     */
    @JvmName("xpawgpugshhxablb")
    public suspend fun cosmosDbAccountResourceId(`value`: Output<String>) {
        this.cosmosDbAccountResourceId = value
    }

    /**
     * @param value The name of an existing container in the Cosmos DB database.
     */
    @JvmName("xvhvuahxsowqbjeo")
    public suspend fun cosmosDbContainer(`value`: Output<String>) {
        this.cosmosDbContainer = value
    }

    /**
     * @param value The name of an existing database in the Cosmos DB account.
     */
    @JvmName("anumnjddioxvbjux")
    public suspend fun cosmosDbDatabase(`value`: Output<String>) {
        this.cosmosDbDatabase = value
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("jtvhfvjmafbpsdqk")
    public suspend fun dataConnectionName(`value`: Output<String>) {
        this.dataConnectionName = value
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("ktwgileptogbdowp")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'CosmosDb'.
     */
    @JvmName("hsgqajtrsmjmuelm")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("lbbvhpmovuvvoxwm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB.
     */
    @JvmName("qgxjenqnqrbrenrj")
    public suspend fun managedIdentityResourceId(`value`: Output<String>) {
        this.managedIdentityResourceId = value
    }

    /**
     * @param value The name of an existing mapping rule to use when ingesting the retrieved data.
     */
    @JvmName("lgkgfounpnuwjwmc")
    public suspend fun mappingRuleName(`value`: Output<String>) {
        this.mappingRuleName = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("ujullguubppiduuv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Optional. If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date.
     */
    @JvmName("sbkxqwqcixijsrko")
    public suspend fun retrievalStartDate(`value`: Output<String>) {
        this.retrievalStartDate = value
    }

    /**
     * @param value The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table.
     */
    @JvmName("sbupqmleveufotfi")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("ghpeevksnxxbjalc")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The resource ID of the Cosmos DB account used to create the data connection.
     */
    @JvmName("ppshenmuwnobduly")
    public suspend fun cosmosDbAccountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cosmosDbAccountResourceId = mapped
    }

    /**
     * @param value The name of an existing container in the Cosmos DB database.
     */
    @JvmName("guebkvxhdjftsamg")
    public suspend fun cosmosDbContainer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cosmosDbContainer = mapped
    }

    /**
     * @param value The name of an existing database in the Cosmos DB account.
     */
    @JvmName("tctnljbjfrfappsg")
    public suspend fun cosmosDbDatabase(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cosmosDbDatabase = mapped
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("dkmxqksgxwyuvoxp")
    public suspend fun dataConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectionName = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("hrxouottrkifpako")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'CosmosDb'.
     */
    @JvmName("okfcwmjhnehycuyy")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("wnlwtewkbtfesbor")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB.
     */
    @JvmName("ouhbpwyeeqrgajcy")
    public suspend fun managedIdentityResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedIdentityResourceId = mapped
    }

    /**
     * @param value The name of an existing mapping rule to use when ingesting the retrieved data.
     */
    @JvmName("rnsdcyvxxhdjkqtw")
    public suspend fun mappingRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingRuleName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("aywgokslbjdddfvm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Optional. If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date.
     */
    @JvmName("mnoeavfxawpjeebx")
    public suspend fun retrievalStartDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retrievalStartDate = mapped
    }

    /**
     * @param value The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table.
     */
    @JvmName("vtrmlsyupcgyjyru")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): CosmosDbDataConnectionArgs = CosmosDbDataConnectionArgs(
        clusterName = clusterName,
        cosmosDbAccountResourceId = cosmosDbAccountResourceId,
        cosmosDbContainer = cosmosDbContainer,
        cosmosDbDatabase = cosmosDbDatabase,
        dataConnectionName = dataConnectionName,
        databaseName = databaseName,
        kind = kind,
        location = location,
        managedIdentityResourceId = managedIdentityResourceId,
        mappingRuleName = mappingRuleName,
        resourceGroupName = resourceGroupName,
        retrievalStartDate = retrievalStartDate,
        tableName = tableName,
    )
}
