@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventHubConnection].
 */
@PulumiTagMarker
public class EventHubConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventHubConnectionArgs = EventHubConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventHubConnectionArgsBuilder.() -> Unit) {
        val builder = EventHubConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventHubConnection {
        val builtJavaResource = com.pulumi.azurenative.kusto.EventHubConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventHubConnection(builtJavaResource)
    }
}

/**
 * Class representing an event hub connection.
 * Azure REST API version: 2018-09-07-preview. Prior API version in Azure Native 1.x: 2018-09-07-preview.
 * ## Example Usage
 * ### KustoEventHubConnectionsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubConnection = new AzureNative.Kusto.EventHubConnection("eventHubConnection", new()
 *     {
 *         ClusterName = "KustoClusterRPTest4",
 *         ConsumerGroup = "testConsumerGroup1",
 *         DatabaseName = "KustoDatabase8",
 *         EventHubConnectionName = "kustoeventhubconnection1",
 *         EventHubResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventHubConnection(ctx, "eventHubConnection", &kusto.EventHubConnectionArgs{
 * 			ClusterName:            pulumi.String("KustoClusterRPTest4"),
 * 			ConsumerGroup:          pulumi.String("testConsumerGroup1"),
 * 			DatabaseName:           pulumi.String("KustoDatabase8"),
 * 			EventHubConnectionName: pulumi.String("kustoeventhubconnection1"),
 * 			EventHubResourceId:     pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1"),
 * 			Location:               pulumi.String("westus"),
 * 			ResourceGroupName:      pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventHubConnection;
 * import com.pulumi.azurenative.kusto.EventHubConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubConnection = new EventHubConnection("eventHubConnection", EventHubConnectionArgs.builder()
 *             .clusterName("KustoClusterRPTest4")
 *             .consumerGroup("testConsumerGroup1")
 *             .databaseName("KustoDatabase8")
 *             .eventHubConnectionName("kustoeventhubconnection1")
 *             .eventHubResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:EventHubConnection KustoClusterRPTest4/KustoDatabase8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/eventhubconnections/{eventHubConnectionName}
 * ```
 */
public class EventHubConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.kusto.EventHubConnection,
) : KotlinCustomResource(javaResource, EventHubConnectionMapper) {
    /**
     * The event hub consumer group.
     */
    public val consumerGroup: Output<String>
        get() = javaResource.consumerGroup().applyValue({ args0 -> args0 })

    /**
     * The data format of the message. Optionally the data format can be added to each message.
     */
    public val dataFormat: Output<String>?
        get() = javaResource.dataFormat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the event hub to be used to create a data connection.
     */
    public val eventHubResourceId: Output<String>
        get() = javaResource.eventHubResourceId().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    public val mappingRuleName: Output<String>?
        get() = javaResource.mappingRuleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    public val tableName: Output<String>?
        get() = javaResource.tableName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EventHubConnectionMapper : ResourceMapper<EventHubConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kusto.EventHubConnection::class == javaResource::class

    override fun map(javaResource: Resource): EventHubConnection = EventHubConnection(
        javaResource as
            com.pulumi.azurenative.kusto.EventHubConnection,
    )
}

/**
 * @see [EventHubConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventHubConnection].
 */
public suspend fun eventHubConnection(
    name: String,
    block: suspend EventHubConnectionResourceBuilder.() -> Unit,
): EventHubConnection {
    val builder = EventHubConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventHubConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventHubConnection(name: String): EventHubConnection {
    val builder = EventHubConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
