@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.IotHubDataConnectionArgs.builder
import com.pulumi.azurenative.kusto.kotlin.enums.DatabaseRouting
import com.pulumi.azurenative.kusto.kotlin.enums.IotHubDataFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class representing an iot hub data connection.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### KustoDataConnectionsCosmosDbCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubDataConnection = new AzureNative.Kusto.IotHubDataConnection("iotHubDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase1",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewIotHubDataConnection(ctx, "iotHubDataConnection", &kusto.IotHubDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase1"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.IotHubDataConnection;
 * import com.pulumi.azurenative.kusto.IotHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubDataConnection = new IotHubDataConnection("iotHubDataConnection", IotHubDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase1")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubDataConnection = new AzureNative.Kusto.IotHubDataConnection("iotHubDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewIotHubDataConnection(ctx, "iotHubDataConnection", &kusto.IotHubDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.IotHubDataConnection;
 * import com.pulumi.azurenative.kusto.IotHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubDataConnection = new IotHubDataConnection("iotHubDataConnection", IotHubDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsEventGridCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubDataConnection = new AzureNative.Kusto.IotHubDataConnection("iotHubDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewIotHubDataConnection(ctx, "iotHubDataConnection", &kusto.IotHubDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.IotHubDataConnection;
 * import com.pulumi.azurenative.kusto.IotHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubDataConnection = new IotHubDataConnection("iotHubDataConnection", IotHubDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:IotHubDataConnection kustoCluster/KustoDatabase8/dataConnectionTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}
 * ```
 * @property clusterName The name of the Kusto cluster.
 * @property consumerGroup The iot hub consumer group.
 * @property dataConnectionName The name of the data connection.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property databaseRouting Indication for database routing information from the data connection, by default only database routing information is allowed
 * @property eventSystemProperties System properties of the iot hub
 * @property iotHubResourceId The resource ID of the Iot hub to be used to create a data connection.
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'IotHub'.
 * @property location Resource location.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 * @property retrievalStartDate When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only retrieve events retained by the Event hub, based on its retention period.
 * @property sharedAccessPolicyName The name of the share access policy
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 */
public data class IotHubDataConnectionArgs(
    public val clusterName: Output<String>? = null,
    public val consumerGroup: Output<String>? = null,
    public val dataConnectionName: Output<String>? = null,
    public val dataFormat: Output<Either<String, IotHubDataFormat>>? = null,
    public val databaseName: Output<String>? = null,
    public val databaseRouting: Output<Either<String, DatabaseRouting>>? = null,
    public val eventSystemProperties: Output<List<String>>? = null,
    public val iotHubResourceId: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mappingRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retrievalStartDate: Output<String>? = null,
    public val sharedAccessPolicyName: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.IotHubDataConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.IotHubDataConnectionArgs =
        com.pulumi.azurenative.kusto.IotHubDataConnectionArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .consumerGroup(consumerGroup?.applyValue({ args0 -> args0 }))
            .dataConnectionName(dataConnectionName?.applyValue({ args0 -> args0 }))
            .dataFormat(
                dataFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .databaseRouting(
                databaseRouting?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .eventSystemProperties(eventSystemProperties?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .iotHubResourceId(iotHubResourceId?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mappingRuleName(mappingRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retrievalStartDate(retrievalStartDate?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyName(sharedAccessPolicyName?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IotHubDataConnectionArgs].
 */
@PulumiTagMarker
public class IotHubDataConnectionArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var consumerGroup: Output<String>? = null

    private var dataConnectionName: Output<String>? = null

    private var dataFormat: Output<Either<String, IotHubDataFormat>>? = null

    private var databaseName: Output<String>? = null

    private var databaseRouting: Output<Either<String, DatabaseRouting>>? = null

    private var eventSystemProperties: Output<List<String>>? = null

    private var iotHubResourceId: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var mappingRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retrievalStartDate: Output<String>? = null

    private var sharedAccessPolicyName: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("viuponrguwiiaddg")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The iot hub consumer group.
     */
    @JvmName("matuynbcrpqonxja")
    public suspend fun consumerGroup(`value`: Output<String>) {
        this.consumerGroup = value
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("ucbxbsqpwjhbjjdk")
    public suspend fun dataConnectionName(`value`: Output<String>) {
        this.dataConnectionName = value
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("brdsldkhlbrrdsvg")
    public suspend fun dataFormat(`value`: Output<Either<String, IotHubDataFormat>>) {
        this.dataFormat = value
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("xrqklndgesltpjvb")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("ksrgkdbvdmdcpxqk")
    public suspend fun databaseRouting(`value`: Output<Either<String, DatabaseRouting>>) {
        this.databaseRouting = value
    }

    /**
     * @param value System properties of the iot hub
     */
    @JvmName("qaftqhespvumqdnm")
    public suspend fun eventSystemProperties(`value`: Output<List<String>>) {
        this.eventSystemProperties = value
    }

    @JvmName("yqkyisbgxpsljqcu")
    public suspend fun eventSystemProperties(vararg values: Output<String>) {
        this.eventSystemProperties = Output.all(values.asList())
    }

    /**
     * @param values System properties of the iot hub
     */
    @JvmName("cypjjbvsqxoyhqgm")
    public suspend fun eventSystemProperties(values: List<Output<String>>) {
        this.eventSystemProperties = Output.all(values)
    }

    /**
     * @param value The resource ID of the Iot hub to be used to create a data connection.
     */
    @JvmName("cbicqhqodsmgujfw")
    public suspend fun iotHubResourceId(`value`: Output<String>) {
        this.iotHubResourceId = value
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'IotHub'.
     */
    @JvmName("oamwxvkwioadwioh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tnvaiddbbfyjvciq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("caatuwcfqfgocylq")
    public suspend fun mappingRuleName(`value`: Output<String>) {
        this.mappingRuleName = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("tixstyeswfcytshf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only retrieve events retained by the Event hub, based on its retention period.
     */
    @JvmName("yrnfbvbrbmdjnsks")
    public suspend fun retrievalStartDate(`value`: Output<String>) {
        this.retrievalStartDate = value
    }

    /**
     * @param value The name of the share access policy
     */
    @JvmName("ivjyaxcthenaknuk")
    public suspend fun sharedAccessPolicyName(`value`: Output<String>) {
        this.sharedAccessPolicyName = value
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("ompiiowrtwoncbsw")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("fgfnauppgtrhpekv")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The iot hub consumer group.
     */
    @JvmName("jnxstrgqnmakhsfi")
    public suspend fun consumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroup = mapped
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("kekkfurhavuojahm")
    public suspend fun dataConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectionName = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("pqxdcyfexhinrxbl")
    public suspend fun dataFormat(`value`: Either<String, IotHubDataFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("jhaolckvvsdgwgoy")
    public fun dataFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IotHubDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("gnrgwkwucpaslplb")
    public fun dataFormat(`value`: IotHubDataFormat) {
        val toBeMapped = Either.ofRight<String, IotHubDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("nkchnrawwvnqhtwn")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("gyiyrvbkebjmvuur")
    public suspend fun databaseRouting(`value`: Either<String, DatabaseRouting>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseRouting = mapped
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("qhduttjmddqqbldh")
    public fun databaseRouting(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatabaseRouting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseRouting = mapped
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("ujxlmhdmaxhacjma")
    public fun databaseRouting(`value`: DatabaseRouting) {
        val toBeMapped = Either.ofRight<String, DatabaseRouting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseRouting = mapped
    }

    /**
     * @param value System properties of the iot hub
     */
    @JvmName("lbjkbvtcvcfitqda")
    public suspend fun eventSystemProperties(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSystemProperties = mapped
    }

    /**
     * @param values System properties of the iot hub
     */
    @JvmName("swywvwxolvhrtsab")
    public suspend fun eventSystemProperties(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventSystemProperties = mapped
    }

    /**
     * @param value The resource ID of the Iot hub to be used to create a data connection.
     */
    @JvmName("jfjmueuowrtvqlvm")
    public suspend fun iotHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotHubResourceId = mapped
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'IotHub'.
     */
    @JvmName("gersipyhntinjpgh")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tukcmvnpgffjmntn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("ixdjniijevxryrpy")
    public suspend fun mappingRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingRuleName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("brnjykfdblfjotvq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only retrieve events retained by the Event hub, based on its retention period.
     */
    @JvmName("toujhlpilwbpkodi")
    public suspend fun retrievalStartDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retrievalStartDate = mapped
    }

    /**
     * @param value The name of the share access policy
     */
    @JvmName("aqxefekebujciwdr")
    public suspend fun sharedAccessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyName = mapped
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("esidysiqpjjuloas")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): IotHubDataConnectionArgs = IotHubDataConnectionArgs(
        clusterName = clusterName,
        consumerGroup = consumerGroup,
        dataConnectionName = dataConnectionName,
        dataFormat = dataFormat,
        databaseName = databaseName,
        databaseRouting = databaseRouting,
        eventSystemProperties = eventSystemProperties,
        iotHubResourceId = iotHubResourceId,
        kind = kind,
        location = location,
        mappingRuleName = mappingRuleName,
        resourceGroupName = resourceGroupName,
        retrievalStartDate = retrievalStartDate,
        sharedAccessPolicyName = sharedAccessPolicyName,
        tableName = tableName,
    )
}
