@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.kusto.kotlin.inputs.PrivateLinkServiceConnectionStatePropertyArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.PrivateLinkServiceConnectionStatePropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A private endpoint connection
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-08-27.
 * Other available API versions: 2023-05-02, 2023-08-15.
 * ## Example Usage
 * ### Approve or reject a private endpoint connection with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.Kusto.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         ClusterName = "kustoclusterrptest4",
 *         PrivateEndpointConnectionName = "privateEndpointTest",
 *         PrivateLinkServiceConnectionState = new AzureNative.Kusto.Inputs.PrivateLinkServiceConnectionStatePropertyArgs
 *         {
 *             Description = "Approved by johndoe@contoso.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &kusto.PrivateEndpointConnectionArgs{
 * 			ClusterName:                   pulumi.String("kustoclusterrptest4"),
 * 			PrivateEndpointConnectionName: pulumi.String("privateEndpointTest"),
 * 			PrivateLinkServiceConnectionState: &kusto.PrivateLinkServiceConnectionStatePropertyArgs{
 * 				Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.PrivateEndpointConnection;
 * import com.pulumi.azurenative.kusto.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.kusto.inputs.PrivateLinkServiceConnectionStatePropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .clusterName("kustoclusterrptest4")
 *             .privateEndpointConnectionName("privateEndpointTest")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStatePropertyArgs.builder()
 *                 .description("Approved by johndoe@contoso.com")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:PrivateEndpointConnection privateEndpointTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property clusterName The name of the Kusto cluster.
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property privateLinkServiceConnectionState Connection State of the Private Endpoint Connection.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class PrivateEndpointConnectionArgs(
    public val clusterName: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStatePropertyArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.kusto.PrivateEndpointConnectionArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState:
        Output<PrivateLinkServiceConnectionStatePropertyArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("qeriwuajieuwxyqu")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("mvqxbrysbryllmve")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Connection State of the Private Endpoint Connection.
     */
    @JvmName("yhcjehfmmgisschr")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStatePropertyArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("squbkrhqiplhcqgn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("crcfrohucigihlsu")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("otljvdcliiiaqwac")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Connection State of the Private Endpoint Connection.
     */
    @JvmName("hcvhgsgskwlsdosw")
    public suspend fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStatePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Connection State of the Private Endpoint Connection.
     */
    @JvmName("gvaumhlvypxxbtat")
    public suspend fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStatePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStatePropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("xhkkincmntbpvssb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        clusterName = clusterName,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
    )
}
