@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Script].
 */
@PulumiTagMarker
public class ScriptResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScriptArgs = ScriptArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScriptArgsBuilder.() -> Unit) {
        val builder = ScriptArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Script {
        val builtJavaResource = com.pulumi.azurenative.kusto.Script(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Script(builtJavaResource)
    }
}

/**
 * Class representing a database script.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2021-08-27, 2023-05-02, 2023-08-15.
 * ## Example Usage
 * ### KustoScriptsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var script = new AzureNative.Kusto.Script("script", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         ContinueOnErrors = true,
 *         DatabaseName = "KustoDatabase8",
 *         ForceUpdateTag = "2bcf3c21-ffd1-4444-b9dd-e52e00ee53fe",
 *         ResourceGroupName = "kustorptest",
 *         ScriptName = "kustoScript",
 *         ScriptUrl = "https://mysa.blob.core.windows.net/container/script.txt",
 *         ScriptUrlSasToken = "?sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=********************************",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewScript(ctx, "script", &kusto.ScriptArgs{
 * 			ClusterName:       pulumi.String("kustoCluster"),
 * 			ContinueOnErrors:  pulumi.Bool(true),
 * 			DatabaseName:      pulumi.String("KustoDatabase8"),
 * 			ForceUpdateTag:    pulumi.String("2bcf3c21-ffd1-4444-b9dd-e52e00ee53fe"),
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 			ScriptName:        pulumi.String("kustoScript"),
 * 			ScriptUrl:         pulumi.String("https://mysa.blob.core.windows.net/container/script.txt"),
 * 			ScriptUrlSasToken: pulumi.String("?sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=********************************"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.Script;
 * import com.pulumi.azurenative.kusto.ScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var script = new Script("script", ScriptArgs.builder()
 *             .clusterName("kustoCluster")
 *             .continueOnErrors(true)
 *             .databaseName("KustoDatabase8")
 *             .forceUpdateTag("2bcf3c21-ffd1-4444-b9dd-e52e00ee53fe")
 *             .resourceGroupName("kustorptest")
 *             .scriptName("kustoScript")
 *             .scriptUrl("https://mysa.blob.core.windows.net/container/script.txt")
 *             .scriptUrlSasToken("?sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=********************************")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:Script kustoCluster/KustoDatabase8/kustoScript /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/scripts/{scriptName}
 * ```
 */
public class Script internal constructor(
    override val javaResource: com.pulumi.azurenative.kusto.Script,
) : KotlinCustomResource(javaResource, ScriptMapper) {
    /**
     * Flag that indicates whether to continue if one of the command fails.
     */
    public val continueOnErrors: Output<Boolean>?
        get() = javaResource.continueOnErrors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique string. If changed the script will be applied again.
     */
    public val forceUpdateTag: Output<String>?
        get() = javaResource.forceUpdateTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The url to the KQL script blob file. Must not be used together with scriptContent property
     */
    public val scriptUrl: Output<String>?
        get() = javaResource.scriptUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScriptMapper : ResourceMapper<Script> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kusto.Script::class == javaResource::class

    override fun map(javaResource: Resource): Script = Script(
        javaResource as
            com.pulumi.azurenative.kusto.Script,
    )
}

/**
 * @see [Script].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Script].
 */
public suspend fun script(name: String, block: suspend ScriptResourceBuilder.() -> Unit): Script {
    val builder = ScriptResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Script].
 * @param name The _unique_ name of the resulting resource.
 */
public fun script(name: String): Script {
    val builder = ScriptResourceBuilder()
    builder.name(name)
    return builder.build()
}
