@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The name of blob storage event type to process.
 */
public enum class BlobStorageEventType(
    public val javaValue: com.pulumi.azurenative.kusto.enums.BlobStorageEventType,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.enums.BlobStorageEventType> {
    Microsoft_Storage_BlobCreated(com.pulumi.azurenative.kusto.enums.BlobStorageEventType.Microsoft_Storage_BlobCreated),
    Microsoft_Storage_BlobRenamed(com.pulumi.azurenative.kusto.enums.BlobStorageEventType.Microsoft_Storage_BlobRenamed),
    ;

    override fun toJava(): com.pulumi.azurenative.kusto.enums.BlobStorageEventType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.enums.BlobStorageEventType): BlobStorageEventType = BlobStorageEventType.values().first { it.javaValue == javaType }
    }
}
