@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether or not to restrict outbound network access.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 */
public enum class ClusterNetworkAccessFlag(
    public val javaValue: com.pulumi.azurenative.kusto.enums.ClusterNetworkAccessFlag,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.enums.ClusterNetworkAccessFlag> {
    Enabled(com.pulumi.azurenative.kusto.enums.ClusterNetworkAccessFlag.Enabled),
    Disabled(com.pulumi.azurenative.kusto.enums.ClusterNetworkAccessFlag.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.kusto.enums.ClusterNetworkAccessFlag = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.enums.ClusterNetworkAccessFlag): ClusterNetworkAccessFlag =
            ClusterNetworkAccessFlag.values().first { it.javaValue == javaType }
    }
}
