@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.GetClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the Kusto cluster.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class GetClusterPlainArgs(
    public val clusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.GetClusterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.GetClusterPlainArgs =
        com.pulumi.azurenative.kusto.inputs.GetClusterPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterPlainArgs].
 */
@PulumiTagMarker
public class GetClusterPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("cqxtqslmnddaqdss")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("vcheusqkyentdgtt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetClusterPlainArgs = GetClusterPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
