@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.GetEventHubConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the Kusto cluster.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property eventHubConnectionName The name of the event hub connection.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class GetEventHubConnectionPlainArgs(
    public val clusterName: String,
    public val databaseName: String,
    public val eventHubConnectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.GetEventHubConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.GetEventHubConnectionPlainArgs =
        com.pulumi.azurenative.kusto.inputs.GetEventHubConnectionPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .eventHubConnectionName(eventHubConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEventHubConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetEventHubConnectionPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var databaseName: String? = null

    private var eventHubConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("ehgaugskshnlljmk")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("jstkidegqdeuywou")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the event hub connection.
     */
    @JvmName("ocjltguiwgxkodlf")
    public suspend fun eventHubConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventHubConnectionName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("kngewuldemmsyybc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEventHubConnectionPlainArgs = GetEventHubConnectionPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        eventHubConnectionName = eventHubConnectionName ?: throw
            PulumiNullFieldException("eventHubConnectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
