@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.GetManagedPrivateEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the Kusto cluster.
 * @property managedPrivateEndpointName The name of the managed private endpoint.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class GetManagedPrivateEndpointPlainArgs(
    public val clusterName: String,
    public val managedPrivateEndpointName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.GetManagedPrivateEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.GetManagedPrivateEndpointPlainArgs =
        com.pulumi.azurenative.kusto.inputs.GetManagedPrivateEndpointPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .managedPrivateEndpointName(managedPrivateEndpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedPrivateEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetManagedPrivateEndpointPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var managedPrivateEndpointName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("viycowdvoxruoboi")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the managed private endpoint.
     */
    @JvmName("xiyvsmhtebjwpxas")
    public suspend fun managedPrivateEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedPrivateEndpointName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("qsccvcdsmefdvilu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedPrivateEndpointPlainArgs = GetManagedPrivateEndpointPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        managedPrivateEndpointName = managedPrivateEndpointName ?: throw
            PulumiNullFieldException("managedPrivateEndpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
