@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.LanguageExtensionsListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The list of language extension objects.
 * @property value The list of language extensions.
 */
public data class LanguageExtensionsListArgs(
    public val `value`: Output<List<LanguageExtensionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.LanguageExtensionsListArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.LanguageExtensionsListArgs =
        com.pulumi.azurenative.kusto.inputs.LanguageExtensionsListArgs.builder()
            .`value`(
                `value`?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [LanguageExtensionsListArgs].
 */
@PulumiTagMarker
public class LanguageExtensionsListArgsBuilder internal constructor() {
    private var `value`: Output<List<LanguageExtensionArgs>>? = null

    /**
     * @param value The list of language extensions.
     */
    @JvmName("dgorcfllovkhgkbt")
    public suspend fun `value`(`value`: Output<List<LanguageExtensionArgs>>) {
        this.`value` = value
    }

    @JvmName("rhmspwdlsltjwwwa")
    public suspend fun `value`(vararg values: Output<LanguageExtensionArgs>) {
        this.`value` = Output.all(values.asList())
    }

    /**
     * @param values The list of language extensions.
     */
    @JvmName("lejqfxormvniasvb")
    public suspend fun `value`(values: List<Output<LanguageExtensionArgs>>) {
        this.`value` = Output.all(values)
    }

    /**
     * @param value The list of language extensions.
     */
    @JvmName("rwkgcwcvpvwgonxr")
    public suspend fun `value`(`value`: List<LanguageExtensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param argument The list of language extensions.
     */
    @JvmName("vdbikkbjyvclehye")
    public suspend fun `value`(argument: List<suspend LanguageExtensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LanguageExtensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param argument The list of language extensions.
     */
    @JvmName("evmlvhpetyvahldx")
    public suspend fun `value`(vararg argument: suspend LanguageExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LanguageExtensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param argument The list of language extensions.
     */
    @JvmName("xurxxjxkjfbqsiop")
    public suspend fun `value`(argument: suspend LanguageExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LanguageExtensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.`value` = mapped
    }

    /**
     * @param values The list of language extensions.
     */
    @JvmName("vidbmslokhttlbet")
    public suspend fun `value`(vararg values: LanguageExtensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): LanguageExtensionsListArgs = LanguageExtensionsListArgs(
        `value` = `value`,
    )
}
