@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.TrustedExternalTenantArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a tenant ID that is trusted by the cluster.
 * @property value GUID representing an external tenant.
 */
public data class TrustedExternalTenantArgs(
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.TrustedExternalTenantArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.TrustedExternalTenantArgs =
        com.pulumi.azurenative.kusto.inputs.TrustedExternalTenantArgs.builder()
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustedExternalTenantArgs].
 */
@PulumiTagMarker
public class TrustedExternalTenantArgsBuilder internal constructor() {
    private var `value`: Output<String>? = null

    /**
     * @param value GUID representing an external tenant.
     */
    @JvmName("cdoeabhsivadvnuv")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value GUID representing an external tenant.
     */
    @JvmName("yiysxncnpxgybjup")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TrustedExternalTenantArgs = TrustedExternalTenantArgs(
        `value` = `value`,
    )
}
