@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.VirtualNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A class that contains virtual network definition.
 * @property dataManagementPublicIpId Data management's service public IP address resource id.
 * @property enginePublicIpId Engine service's public IP address resource id.
 * @property subnetId The subnet resource id.
 */
public data class VirtualNetworkConfigurationArgs(
    public val dataManagementPublicIpId: Output<String>,
    public val enginePublicIpId: Output<String>,
    public val subnetId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.VirtualNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.VirtualNetworkConfigurationArgs =
        com.pulumi.azurenative.kusto.inputs.VirtualNetworkConfigurationArgs.builder()
            .dataManagementPublicIpId(dataManagementPublicIpId.applyValue({ args0 -> args0 }))
            .enginePublicIpId(enginePublicIpId.applyValue({ args0 -> args0 }))
            .subnetId(subnetId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualNetworkConfigurationArgsBuilder internal constructor() {
    private var dataManagementPublicIpId: Output<String>? = null

    private var enginePublicIpId: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value Data management's service public IP address resource id.
     */
    @JvmName("tutkhpritplyxbmn")
    public suspend fun dataManagementPublicIpId(`value`: Output<String>) {
        this.dataManagementPublicIpId = value
    }

    /**
     * @param value Engine service's public IP address resource id.
     */
    @JvmName("hfqahpfdyfsprvot")
    public suspend fun enginePublicIpId(`value`: Output<String>) {
        this.enginePublicIpId = value
    }

    /**
     * @param value The subnet resource id.
     */
    @JvmName("kdxbaaikeaqfuiue")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Data management's service public IP address resource id.
     */
    @JvmName("ibylxhxcdmmoyfwi")
    public suspend fun dataManagementPublicIpId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataManagementPublicIpId = mapped
    }

    /**
     * @param value Engine service's public IP address resource id.
     */
    @JvmName("fblewtyunfuhqqhf")
    public suspend fun enginePublicIpId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enginePublicIpId = mapped
    }

    /**
     * @param value The subnet resource id.
     */
    @JvmName("xhvvhpcdpkkobygi")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): VirtualNetworkConfigurationArgs = VirtualNetworkConfigurationArgs(
        dataManagementPublicIpId = dataManagementPublicIpId ?: throw
            PulumiNullFieldException("dataManagementPublicIpId"),
        enginePublicIpId = enginePublicIpId ?: throw PulumiNullFieldException("enginePublicIpId"),
        subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
    )
}
