@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Azure SKU definition.
 * @property capacity The number of instances of the cluster.
 * @property name SKU name.
 * @property tier SKU tier.
 */
public data class AzureSkuResponse(
    public val capacity: Int? = null,
    public val name: String,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.AzureSkuResponse): AzureSkuResponse = AzureSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tier = javaType.tier(),
        )
    }
}
