@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * A class that contains database statistics information.
 * @property size The database size - the total size of compressed data and index in bytes.
 */
public data class DatabaseStatisticsResponse(
    public val size: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.DatabaseStatisticsResponse): DatabaseStatisticsResponse = DatabaseStatisticsResponse(
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
        )
    }
}
