@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A class representing follower database request.
 * @property attachedDatabaseConfigurationName Resource name of the attached database configuration in the follower cluster.
 * @property clusterResourceId Resource id of the cluster that follows a database owned by this cluster.
 * @property databaseName The database name owned by this cluster that was followed. * in case following all databases.
 * @property databaseShareOrigin The origin of the following setup.
 * @property tableLevelSharingProperties Table level sharing specifications
 */
public data class FollowerDatabaseDefinitionResponse(
    public val attachedDatabaseConfigurationName: String,
    public val clusterResourceId: String,
    public val databaseName: String,
    public val databaseShareOrigin: String,
    public val tableLevelSharingProperties: TableLevelSharingPropertiesResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.FollowerDatabaseDefinitionResponse): FollowerDatabaseDefinitionResponse = FollowerDatabaseDefinitionResponse(
            attachedDatabaseConfigurationName = javaType.attachedDatabaseConfigurationName(),
            clusterResourceId = javaType.clusterResourceId(),
            databaseName = javaType.databaseName(),
            databaseShareOrigin = javaType.databaseShareOrigin(),
            tableLevelSharingProperties = javaType.tableLevelSharingProperties().let({ args0 ->
                com.pulumi.azurenative.kusto.kotlin.outputs.TableLevelSharingPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
