@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class representing an attached database configuration.
 * @property attachedDatabaseNames The list of databases from the clusterResourceId which are currently attached to the cluster.
 * @property clusterResourceId The resource id of the cluster where the databases you would like to attach reside.
 * @property databaseName The name of the database which you would like to attach, use * if you want to follow all current and future databases.
 * @property databaseNameOverride Overrides the original database name. Relevant only when attaching to a specific database.
 * @property databaseNamePrefix Adds a prefix to the attached databases name. When following an entire cluster, that prefix would be added to all of the databases original names from leader cluster.
 * @property defaultPrincipalsModificationKind The default principals modification kind
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location Resource location.
 * @property name The name of the resource
 * @property provisioningState The provisioned state of the resource.
 * @property tableLevelSharingProperties Table level sharing specifications
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAttachedDatabaseConfigurationResult(
    public val attachedDatabaseNames: List<String>,
    public val clusterResourceId: String,
    public val databaseName: String,
    public val databaseNameOverride: String? = null,
    public val databaseNamePrefix: String? = null,
    public val defaultPrincipalsModificationKind: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val tableLevelSharingProperties: TableLevelSharingPropertiesResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.GetAttachedDatabaseConfigurationResult): GetAttachedDatabaseConfigurationResult = GetAttachedDatabaseConfigurationResult(
            attachedDatabaseNames = javaType.attachedDatabaseNames().map({ args0 -> args0 }),
            clusterResourceId = javaType.clusterResourceId(),
            databaseName = javaType.databaseName(),
            databaseNameOverride = javaType.databaseNameOverride().map({ args0 -> args0 }).orElse(null),
            databaseNamePrefix = javaType.databaseNamePrefix().map({ args0 -> args0 }).orElse(null),
            defaultPrincipalsModificationKind = javaType.defaultPrincipalsModificationKind(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tableLevelSharingProperties = javaType.tableLevelSharingProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kusto.kotlin.outputs.TableLevelSharingPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
