@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class representing a CosmosDb data connection.
 * @property cosmosDbAccountResourceId The resource ID of the Cosmos DB account used to create the data connection.
 * @property cosmosDbContainer The name of an existing container in the Cosmos DB database.
 * @property cosmosDbDatabase The name of an existing database in the Cosmos DB account.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'CosmosDb'.
 * @property location Resource location.
 * @property managedIdentityObjectId The object ID of the managed identity resource.
 * @property managedIdentityResourceId The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB.
 * @property mappingRuleName The name of an existing mapping rule to use when ingesting the retrieved data.
 * @property name The name of the resource
 * @property provisioningState The provisioned state of the resource.
 * @property retrievalStartDate Optional. If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date.
 * @property tableName The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCosmosDbDataConnectionResult(
    public val cosmosDbAccountResourceId: String,
    public val cosmosDbContainer: String,
    public val cosmosDbDatabase: String,
    public val id: String,
    public val kind: String,
    public val location: String? = null,
    public val managedIdentityObjectId: String,
    public val managedIdentityResourceId: String,
    public val mappingRuleName: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val retrievalStartDate: String? = null,
    public val tableName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.GetCosmosDbDataConnectionResult): GetCosmosDbDataConnectionResult = GetCosmosDbDataConnectionResult(
            cosmosDbAccountResourceId = javaType.cosmosDbAccountResourceId(),
            cosmosDbContainer = javaType.cosmosDbContainer(),
            cosmosDbDatabase = javaType.cosmosDbDatabase(),
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedIdentityObjectId = javaType.managedIdentityObjectId(),
            managedIdentityResourceId = javaType.managedIdentityResourceId(),
            mappingRuleName = javaType.mappingRuleName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            retrievalStartDate = javaType.retrievalStartDate().map({ args0 -> args0 }).orElse(null),
            tableName = javaType.tableName(),
            type = javaType.type(),
        )
    }
}
