@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class representing a managed private endpoint.
 * @property groupId The groupId in which the managed private endpoint is created.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property privateLinkResourceId The ARM resource ID of the resource for which the managed private endpoint is created.
 * @property privateLinkResourceRegion The region of the resource to which the managed private endpoint is created.
 * @property provisioningState The provisioned state of the resource.
 * @property requestMessage The user request message.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetManagedPrivateEndpointResult(
    public val groupId: String,
    public val id: String,
    public val name: String,
    public val privateLinkResourceId: String,
    public val privateLinkResourceRegion: String? = null,
    public val provisioningState: String,
    public val requestMessage: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.GetManagedPrivateEndpointResult): GetManagedPrivateEndpointResult = GetManagedPrivateEndpointResult(
            groupId = javaType.groupId(),
            id = javaType.id(),
            name = javaType.name(),
            privateLinkResourceId = javaType.privateLinkResourceId(),
            privateLinkResourceRegion = javaType.privateLinkResourceRegion().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            requestMessage = javaType.requestMessage().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.kusto.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
