@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Class representing a read write database.
 * @property hotCachePeriod The time the data should be kept in cache for fast queries in TimeSpan.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isFollowed Indicates whether the database is followed.
 * @property kind Kind of the database
 * Expected value is 'ReadWrite'.
 * @property location Resource location.
 * @property name The name of the resource
 * @property provisioningState The provisioned state of the resource.
 * @property softDeletePeriod The time the data should be kept before it stops being accessible to queries in TimeSpan.
 * @property statistics The statistics of the database.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetReadWriteDatabaseResult(
    public val hotCachePeriod: String? = null,
    public val id: String,
    public val isFollowed: Boolean,
    public val kind: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val softDeletePeriod: String? = null,
    public val statistics: DatabaseStatisticsResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.GetReadWriteDatabaseResult): GetReadWriteDatabaseResult = GetReadWriteDatabaseResult(
            hotCachePeriod = javaType.hotCachePeriod().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isFollowed = javaType.isFollowed(),
            kind = javaType.kind(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            softDeletePeriod = javaType.softDeletePeriod().map({ args0 -> args0 }).orElse(null),
            statistics = javaType.statistics().let({ args0 ->
                com.pulumi.azurenative.kusto.kotlin.outputs.DatabaseStatisticsResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
