@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class representing a Kusto sandbox custom image.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property language The language name, for example Python.
 * @property languageVersion The version of the language.
 * @property name The name of the resource
 * @property provisioningState The provisioned state of the resource.
 * @property requirementsFileContent The requirements file content.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSandboxCustomImageResult(
    public val id: String,
    public val language: String,
    public val languageVersion: String,
    public val name: String,
    public val provisioningState: String,
    public val requirementsFileContent: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.GetSandboxCustomImageResult): GetSandboxCustomImageResult = GetSandboxCustomImageResult(
            id = javaType.id(),
            language = javaType.language(),
            languageVersion = javaType.languageVersion(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            requirementsFileContent = javaType.requirementsFileContent().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
