@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the key vault.
 * @property keyName The name of the key vault key.
 * @property keyVaultUri The Uri of the key vault.
 * @property keyVersion The version of the key vault key.
 * @property userIdentity The user assigned identity (ARM resource id) that has access to the key.
 */
public data class KeyVaultPropertiesResponse(
    public val keyName: String? = null,
    public val keyVaultUri: String? = null,
    public val keyVersion: String? = null,
    public val userIdentity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.KeyVaultPropertiesResponse): KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            keyVaultUri = javaType.keyVaultUri().map({ args0 -> args0 }).orElse(null),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
            userIdentity = javaType.userIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
