@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The language extension object.
 * @property languageExtensionImageName The language extension image name.
 * @property languageExtensionName The language extension name.
 */
public data class LanguageExtensionResponse(
    public val languageExtensionImageName: String? = null,
    public val languageExtensionName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.LanguageExtensionResponse): LanguageExtensionResponse = LanguageExtensionResponse(
            languageExtensionImageName = javaType.languageExtensionImageName().map({ args0 ->
                args0
            }).orElse(null),
            languageExtensionName = javaType.languageExtensionName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
