@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.kotlin.outputs.GalleryImageReferenceResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.labservices.kotlin.outputs.GalleryImageReferenceResponse.Companion.toKotlin as galleryImageReferenceResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse.Companion.toKotlin as latestOperationResultResponseToKotlin

/**
 * Builder for [GalleryImage].
 */
@PulumiTagMarker
public class GalleryImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GalleryImageArgs = GalleryImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GalleryImageArgsBuilder.() -> Unit) {
        val builder = GalleryImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GalleryImage {
        val builtJavaResource = com.pulumi.azurenative.labservices.GalleryImage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GalleryImage(builtJavaResource)
    }
}

/**
 * Represents an image from the Azure Marketplace
 * Azure REST API version: 2018-10-15. Prior API version in Azure Native 1.x: 2018-10-15.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:GalleryImage myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labaccounts/{labAccountName}/galleryimages/{galleryImageName}
 * ```
 */
public class GalleryImage internal constructor(
    override val javaResource: com.pulumi.azurenative.labservices.GalleryImage,
) : KotlinCustomResource(javaResource, GalleryImageMapper) {
    /**
     * The author of the gallery image.
     */
    public val author: Output<String>
        get() = javaResource.author().applyValue({ args0 -> args0 })

    /**
     * The creation date of the gallery image.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * The description of the gallery image.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The icon of the gallery image.
     */
    public val icon: Output<String>
        get() = javaResource.icon().applyValue({ args0 -> args0 })

    /**
     * The image reference of the gallery image.
     */
    public val imageReference: Output<GalleryImageReferenceResponse>
        get() = javaResource.imageReference().applyValue({ args0 ->
            args0.let({ args0 ->
                galleryImageReferenceResponseToKotlin(args0)
            })
        })

    /**
     * Indicates whether this gallery image is enabled.
     */
    public val isEnabled: Output<Boolean>?
        get() = javaResource.isEnabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether this gallery has been overridden for this lab account
     */
    public val isOverride: Output<Boolean>?
        get() = javaResource.isOverride().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if the plan has been authorized for programmatic deployment.
     */
    public val isPlanAuthorized: Output<Boolean>?
        get() = javaResource.isPlanAuthorized().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The details of the latest operation. ex: status, error
     */
    public val latestOperationResult: Output<LatestOperationResultResponse>
        get() = javaResource.latestOperationResult().applyValue({ args0 ->
            args0.let({ args0 ->
                latestOperationResultResponseToKotlin(args0)
            })
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The third party plan that applies to this image
     */
    public val planId: Output<String>
        get() = javaResource.planId().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>?
        get() = javaResource.uniqueIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object GalleryImageMapper : ResourceMapper<GalleryImage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.labservices.GalleryImage::class == javaResource::class

    override fun map(javaResource: Resource): GalleryImage = GalleryImage(
        javaResource as
            com.pulumi.azurenative.labservices.GalleryImage,
    )
}

/**
 * @see [GalleryImage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GalleryImage].
 */
public suspend fun galleryImage(
    name: String,
    block: suspend GalleryImageResourceBuilder.() -> Unit,
): GalleryImage {
    val builder = GalleryImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GalleryImage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun galleryImage(name: String): GalleryImage {
    val builder = GalleryImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
