@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.kotlin.outputs.AutoShutdownProfileResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.ConnectionProfileResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.LabNetworkProfileResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.RosterProfileResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.SecurityProfileResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.VirtualMachineProfileResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.labservices.kotlin.outputs.AutoShutdownProfileResponse.Companion.toKotlin as autoShutdownProfileResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.ConnectionProfileResponse.Companion.toKotlin as connectionProfileResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.LabNetworkProfileResponse.Companion.toKotlin as labNetworkProfileResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.RosterProfileResponse.Companion.toKotlin as rosterProfileResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin as securityProfileResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.VirtualMachineProfileResponse.Companion.toKotlin as virtualMachineProfileResponseToKotlin

/**
 * Builder for [Lab].
 */
@PulumiTagMarker
public class LabResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LabArgs = LabArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LabArgsBuilder.() -> Unit) {
        val builder = LabArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Lab {
        val builtJavaResource = com.pulumi.azurenative.labservices.Lab(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Lab(builtJavaResource)
    }
}

/**
 * The lab resource.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2018-10-15.
 * Other available API versions: 2018-10-15, 2023-06-07.
 * ## Example Usage
 * ### putLab
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lab = new AzureNative.LabServices.Lab("lab", new()
 *     {
 *         AutoShutdownProfile = new AzureNative.LabServices.Inputs.AutoShutdownProfileArgs
 *         {
 *             DisconnectDelay = "PT5M",
 *             IdleDelay = "PT5M",
 *             NoConnectDelay = "PT5M",
 *             ShutdownOnDisconnect = AzureNative.LabServices.EnableState.Enabled,
 *             ShutdownOnIdle = AzureNative.LabServices.ShutdownOnIdleMode.UserAbsence,
 *             ShutdownWhenNotConnected = AzureNative.LabServices.EnableState.Enabled,
 *         },
 *         ConnectionProfile = new AzureNative.LabServices.Inputs.ConnectionProfileArgs
 *         {
 *             ClientRdpAccess = AzureNative.LabServices.ConnectionType.Public,
 *             ClientSshAccess = AzureNative.LabServices.ConnectionType.Public,
 *             WebRdpAccess = AzureNative.LabServices.ConnectionType.None,
 *             WebSshAccess = AzureNative.LabServices.ConnectionType.None,
 *         },
 *         Description = "This is a test lab.",
 *         LabName = "testlab",
 *         LabPlanId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.LabServices/labPlans/testlabplan",
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.LabServices.Inputs.LabNetworkProfileArgs
 *         {
 *             SubnetId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default",
 *         },
 *         ResourceGroupName = "testrg123",
 *         SecurityProfile = new AzureNative.LabServices.Inputs.SecurityProfileArgs
 *         {
 *             OpenAccess = AzureNative.LabServices.EnableState.Disabled,
 *         },
 *         Title = "Test Lab",
 *         VirtualMachineProfile = new AzureNative.LabServices.Inputs.VirtualMachineProfileArgs
 *         {
 *             AdditionalCapabilities = new AzureNative.LabServices.Inputs.VirtualMachineAdditionalCapabilitiesArgs
 *             {
 *                 InstallGpuDrivers = AzureNative.LabServices.EnableState.Disabled,
 *             },
 *             AdminUser = new AzureNative.LabServices.Inputs.CredentialsArgs
 *             {
 *                 Username = "test-user",
 *             },
 *             CreateOption = AzureNative.LabServices.CreateOption.TemplateVM,
 *             ImageReference = new AzureNative.LabServices.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "Microsoft",
 *                 Sku = "2019-Datacenter",
 *                 Version = "2019.0.20190410",
 *             },
 *             Sku = new AzureNative.LabServices.Inputs.SkuArgs
 *             {
 *                 Name = "Medium",
 *             },
 *             UsageQuota = "PT10H",
 *             UseSharedPassword = AzureNative.LabServices.EnableState.Disabled,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/labservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := labservices.NewLab(ctx, "lab", &labservices.LabArgs{
 * 			AutoShutdownProfile: &labservices.AutoShutdownProfileArgs{
 * 				DisconnectDelay:          pulumi.String("PT5M"),
 * 				IdleDelay:                pulumi.String("PT5M"),
 * 				NoConnectDelay:           pulumi.String("PT5M"),
 * 				ShutdownOnDisconnect:     labservices.EnableStateEnabled,
 * 				ShutdownOnIdle:           labservices.ShutdownOnIdleModeUserAbsence,
 * 				ShutdownWhenNotConnected: labservices.EnableStateEnabled,
 * 			},
 * 			ConnectionProfile: &labservices.ConnectionProfileArgs{
 * 				ClientRdpAccess: labservices.ConnectionTypePublic,
 * 				ClientSshAccess: labservices.ConnectionTypePublic,
 * 				WebRdpAccess:    labservices.ConnectionTypeNone,
 * 				WebSshAccess:    labservices.ConnectionTypeNone,
 * 			},
 * 			Description: pulumi.String("This is a test lab."),
 * 			LabName:     pulumi.String("testlab"),
 * 			LabPlanId:   pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.LabServices/labPlans/testlabplan"),
 * 			Location:    pulumi.String("westus"),
 * 			NetworkProfile: &labservices.LabNetworkProfileArgs{
 * 				SubnetId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			SecurityProfile: &labservices.SecurityProfileArgs{
 * 				OpenAccess: labservices.EnableStateDisabled,
 * 			},
 * 			Title: pulumi.String("Test Lab"),
 * 			VirtualMachineProfile: &labservices.VirtualMachineProfileArgs{
 * 				AdditionalCapabilities: &labservices.VirtualMachineAdditionalCapabilitiesArgs{
 * 					InstallGpuDrivers: labservices.EnableStateDisabled,
 * 				},
 * 				AdminUser: &labservices.CredentialsArgs{
 * 					Username: pulumi.String("test-user"),
 * 				},
 * 				CreateOption: labservices.CreateOptionTemplateVM,
 * 				ImageReference: &labservices.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("Microsoft"),
 * 					Sku:       pulumi.String("2019-Datacenter"),
 * 					Version:   pulumi.String("2019.0.20190410"),
 * 				},
 * 				Sku: &labservices.SkuArgs{
 * 					Name: pulumi.String("Medium"),
 * 				},
 * 				UsageQuota:        pulumi.String("PT10H"),
 * 				UseSharedPassword: labservices.EnableStateDisabled,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.labservices.Lab;
 * import com.pulumi.azurenative.labservices.LabArgs;
 * import com.pulumi.azurenative.labservices.inputs.AutoShutdownProfileArgs;
 * import com.pulumi.azurenative.labservices.inputs.ConnectionProfileArgs;
 * import com.pulumi.azurenative.labservices.inputs.LabNetworkProfileArgs;
 * import com.pulumi.azurenative.labservices.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.labservices.inputs.VirtualMachineProfileArgs;
 * import com.pulumi.azurenative.labservices.inputs.VirtualMachineAdditionalCapabilitiesArgs;
 * import com.pulumi.azurenative.labservices.inputs.CredentialsArgs;
 * import com.pulumi.azurenative.labservices.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.labservices.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lab = new Lab("lab", LabArgs.builder()
 *             .autoShutdownProfile(AutoShutdownProfileArgs.builder()
 *                 .disconnectDelay("PT5M")
 *                 .idleDelay("PT5M")
 *                 .noConnectDelay("PT5M")
 *                 .shutdownOnDisconnect("Enabled")
 *                 .shutdownOnIdle("UserAbsence")
 *                 .shutdownWhenNotConnected("Enabled")
 *                 .build())
 *             .connectionProfile(ConnectionProfileArgs.builder()
 *                 .clientRdpAccess("Public")
 *                 .clientSshAccess("Public")
 *                 .webRdpAccess("None")
 *                 .webSshAccess("None")
 *                 .build())
 *             .description("This is a test lab.")
 *             .labName("testlab")
 *             .labPlanId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.LabServices/labPlans/testlabplan")
 *             .location("westus")
 *             .networkProfile(LabNetworkProfileArgs.builder()
 *                 .subnetId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default")
 *                 .build())
 *             .resourceGroupName("testrg123")
 *             .securityProfile(SecurityProfileArgs.builder()
 *                 .openAccess("Disabled")
 *                 .build())
 *             .title("Test Lab")
 *             .virtualMachineProfile(VirtualMachineProfileArgs.builder()
 *                 .additionalCapabilities(VirtualMachineAdditionalCapabilitiesArgs.builder()
 *                     .installGpuDrivers("Disabled")
 *                     .build())
 *                 .adminUser(CredentialsArgs.builder()
 *                     .username("test-user")
 *                     .build())
 *                 .createOption("TemplateVM")
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("Microsoft")
 *                     .sku("2019-Datacenter")
 *                     .version("2019.0.20190410")
 *                     .build())
 *                 .sku(SkuArgs.builder()
 *                     .name("Medium")
 *                     .build())
 *                 .usageQuota("PT10H")
 *                 .useSharedPassword("Disabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:Lab testlabplan /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}
 * ```
 */
public class Lab internal constructor(
    override val javaResource: com.pulumi.azurenative.labservices.Lab,
) : KotlinCustomResource(javaResource, LabMapper) {
    /**
     * The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle.
     */
    public val autoShutdownProfile: Output<AutoShutdownProfileResponse>
        get() = javaResource.autoShutdownProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                autoShutdownProfileResponseToKotlin(args0)
            })
        })

    /**
     * The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open.
     */
    public val connectionProfile: Output<ConnectionProfileResponse>
        get() = javaResource.connectionProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                connectionProfileResponseToKotlin(args0)
            })
        })

    /**
     * The description of the lab.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating a lab via labs.azure.com. Setting a labPlanId on an existing lab provides organization..
     */
    public val labPlanId: Output<String>?
        get() = javaResource.labPlanId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been created.
     */
    public val networkProfile: Output<LabNetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> labNetworkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Current provisioning state of the lab.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The lab user list management profile.
     */
    public val rosterProfile: Output<RosterProfileResponse>?
        get() = javaResource.rosterProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> rosterProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The lab security profile.
     */
    public val securityProfile: Output<SecurityProfileResponse>
        get() = javaResource.securityProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                securityProfileResponseToKotlin(args0)
            })
        })

    /**
     * The lab state.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the lab.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The title of the lab.
     */
    public val title: Output<String>?
        get() = javaResource.title().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The profile used for creating lab virtual machines.
     */
    public val virtualMachineProfile: Output<VirtualMachineProfileResponse>
        get() = javaResource.virtualMachineProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualMachineProfileResponseToKotlin(args0)
            })
        })
}

public object LabMapper : ResourceMapper<Lab> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.labservices.Lab::class == javaResource::class

    override fun map(javaResource: Resource): Lab = Lab(
        javaResource as
            com.pulumi.azurenative.labservices.Lab,
    )
}

/**
 * @see [Lab].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Lab].
 */
public suspend fun lab(name: String, block: suspend LabResourceBuilder.() -> Unit): Lab {
    val builder = LabResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Lab].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lab(name: String): Lab {
    val builder = LabResourceBuilder()
    builder.name(name)
    return builder.build()
}
