@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.LabAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a lab account.
 * Azure REST API version: 2018-10-15. Prior API version in Azure Native 1.x: 2018-10-15.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:LabAccount myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labaccounts/{labAccountName}
 * ```
 * @property enabledRegionSelection Represents if region selection is enabled
 * @property labAccountName The name of the lab Account.
 * @property location The location of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property resourceGroupName The name of the resource group.
 * @property tags The tags of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class LabAccountArgs(
    public val enabledRegionSelection: Output<Boolean>? = null,
    public val labAccountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val uniqueIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.LabAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.LabAccountArgs =
        com.pulumi.azurenative.labservices.LabAccountArgs.builder()
            .enabledRegionSelection(enabledRegionSelection?.applyValue({ args0 -> args0 }))
            .labAccountName(labAccountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .uniqueIdentifier(uniqueIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabAccountArgs].
 */
@PulumiTagMarker
public class LabAccountArgsBuilder internal constructor() {
    private var enabledRegionSelection: Output<Boolean>? = null

    private var labAccountName: Output<String>? = null

    private var location: Output<String>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var uniqueIdentifier: Output<String>? = null

    /**
     * @param value Represents if region selection is enabled
     */
    @JvmName("caqcxjfynmgfiwnn")
    public suspend fun enabledRegionSelection(`value`: Output<Boolean>) {
        this.enabledRegionSelection = value
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("syluflwoitfawjcp")
    public suspend fun labAccountName(`value`: Output<String>) {
        this.labAccountName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("ipyivnvelhtiaqog")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The provisioning status of the resource.
     */
    @JvmName("hvtovefmxurrbuyy")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ipeivcjeqnyefvrk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("gwqucawwlhhamxlc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The unique immutable identifier of a resource (Guid).
     */
    @JvmName("ttwdtmdxbtwywlsu")
    public suspend fun uniqueIdentifier(`value`: Output<String>) {
        this.uniqueIdentifier = value
    }

    /**
     * @param value Represents if region selection is enabled
     */
    @JvmName("hsqeltgkajjthbih")
    public suspend fun enabledRegionSelection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledRegionSelection = mapped
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("jglexckkfdeemitw")
    public suspend fun labAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labAccountName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("nsnsfnogjnsstvag")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The provisioning status of the resource.
     */
    @JvmName("ucjirhuwkjbryunh")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cfrulwkcvmajqffv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("xrfiatiosuvtfvlk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("geilmdqqhtdaucxe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The unique immutable identifier of a resource (Guid).
     */
    @JvmName("dlpojbumjkupjfqo")
    public suspend fun uniqueIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueIdentifier = mapped
    }

    internal fun build(): LabAccountArgs = LabAccountArgs(
        enabledRegionSelection = enabledRegionSelection,
        labAccountName = labAccountName,
        location = location,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        tags = tags,
        uniqueIdentifier = uniqueIdentifier,
    )
}
