@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.LabservicesFunctions.getEnvironmentPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getEnvironmentSettingPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getGalleryImagePlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getGlobalUserEnvironmentPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getGlobalUserOperationBatchStatusPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getGlobalUserOperationStatusPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getGlobalUserPersonalPreferencesPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getLabAccountPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getLabAccountRegionalAvailabilityPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getLabPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getLabPlanPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getSchedulePlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.getUserPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.listGlobalUserEnvironmentsPlain
import com.pulumi.azurenative.labservices.LabservicesFunctions.listGlobalUserLabsPlain
import com.pulumi.azurenative.labservices.kotlin.enums.AddRemove
import com.pulumi.azurenative.labservices.kotlin.inputs.GetEnvironmentPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetEnvironmentPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetEnvironmentSettingPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetEnvironmentSettingPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetGalleryImagePlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetGalleryImagePlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetGlobalUserEnvironmentPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetGlobalUserEnvironmentPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetGlobalUserOperationBatchStatusPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetGlobalUserOperationBatchStatusPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetGlobalUserOperationStatusPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetGlobalUserOperationStatusPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetGlobalUserPersonalPreferencesPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetGlobalUserPersonalPreferencesPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetLabAccountPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetLabAccountPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetLabAccountRegionalAvailabilityPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetLabAccountRegionalAvailabilityPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetLabPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetLabPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetLabPlanPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetLabPlanPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetSchedulePlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetSchedulePlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.GetUserPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.ListGlobalUserEnvironmentsPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.ListGlobalUserEnvironmentsPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.ListGlobalUserLabsPlainArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.ListGlobalUserLabsPlainArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.outputs.GetEnvironmentResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetEnvironmentSettingResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetGalleryImageResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetGlobalUserEnvironmentResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetGlobalUserOperationBatchStatusResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetGlobalUserOperationStatusResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetGlobalUserPersonalPreferencesResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetLabAccountRegionalAvailabilityResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetLabAccountResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetLabPlanResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetLabResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetScheduleResult
import com.pulumi.azurenative.labservices.kotlin.outputs.GetUserResult
import com.pulumi.azurenative.labservices.kotlin.outputs.ListGlobalUserEnvironmentsResult
import com.pulumi.azurenative.labservices.kotlin.outputs.ListGlobalUserLabsResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.labservices.kotlin.outputs.GetEnvironmentResult.Companion.toKotlin as getEnvironmentResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetEnvironmentSettingResult.Companion.toKotlin as getEnvironmentSettingResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetGalleryImageResult.Companion.toKotlin as getGalleryImageResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetGlobalUserEnvironmentResult.Companion.toKotlin as getGlobalUserEnvironmentResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetGlobalUserOperationBatchStatusResult.Companion.toKotlin as getGlobalUserOperationBatchStatusResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetGlobalUserOperationStatusResult.Companion.toKotlin as getGlobalUserOperationStatusResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetGlobalUserPersonalPreferencesResult.Companion.toKotlin as getGlobalUserPersonalPreferencesResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetLabAccountRegionalAvailabilityResult.Companion.toKotlin as getLabAccountRegionalAvailabilityResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetLabAccountResult.Companion.toKotlin as getLabAccountResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetLabPlanResult.Companion.toKotlin as getLabPlanResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetLabResult.Companion.toKotlin as getLabResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetScheduleResult.Companion.toKotlin as getScheduleResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.ListGlobalUserEnvironmentsResult.Companion.toKotlin as listGlobalUserEnvironmentsResultToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.ListGlobalUserLabsResult.Companion.toKotlin as listGlobalUserLabsResultToKotlin

public object LabservicesFunctions {
    /**
     * Get environment
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return Represents an environment instance
     */
    public suspend fun getEnvironment(argument: GetEnvironmentPlainArgs): GetEnvironmentResult =
        getEnvironmentResultToKotlin(getEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getEnvironment].
     * @param environmentName The name of the environment.
     * @param environmentSettingName The name of the environment Setting.
     * @param expand Specify the $expand query. Example: 'properties($expand=networkInterface)'
     * @param labAccountName The name of the lab Account.
     * @param labName The name of the lab.
     * @param resourceGroupName The name of the resource group.
     * @return Represents an environment instance
     */
    public suspend fun getEnvironment(
        environmentName: String,
        environmentSettingName: String,
        expand: String? = null,
        labAccountName: String,
        labName: String,
        resourceGroupName: String,
    ): GetEnvironmentResult {
        val argument = GetEnvironmentPlainArgs(
            environmentName = environmentName,
            environmentSettingName = environmentSettingName,
            expand = expand,
            labAccountName = labAccountName,
            labName = labName,
            resourceGroupName = resourceGroupName,
        )
        return getEnvironmentResultToKotlin(getEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetEnvironmentPlainArgs].
     * @return Represents an environment instance
     */
    public suspend fun getEnvironment(argument: suspend GetEnvironmentPlainArgsBuilder.() -> Unit): GetEnvironmentResult {
        val builder = GetEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnvironmentResultToKotlin(getEnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get environment setting
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return Represents settings of an environment, from which environment instances would be created
     */
    public suspend fun getEnvironmentSetting(argument: GetEnvironmentSettingPlainArgs): GetEnvironmentSettingResult =
        getEnvironmentSettingResultToKotlin(getEnvironmentSettingPlain(argument.toJava()).await())

    /**
     * @see [getEnvironmentSetting].
     * @param environmentSettingName The name of the environment Setting.
     * @param expand Specify the $expand query. Example: 'properties($select=publishingState)'
     * @param labAccountName The name of the lab Account.
     * @param labName The name of the lab.
     * @param resourceGroupName The name of the resource group.
     * @return Represents settings of an environment, from which environment instances would be created
     */
    public suspend fun getEnvironmentSetting(
        environmentSettingName: String,
        expand: String? = null,
        labAccountName: String,
        labName: String,
        resourceGroupName: String,
    ): GetEnvironmentSettingResult {
        val argument = GetEnvironmentSettingPlainArgs(
            environmentSettingName = environmentSettingName,
            expand = expand,
            labAccountName = labAccountName,
            labName = labName,
            resourceGroupName = resourceGroupName,
        )
        return getEnvironmentSettingResultToKotlin(getEnvironmentSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnvironmentSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetEnvironmentSettingPlainArgs].
     * @return Represents settings of an environment, from which environment instances would be created
     */
    public suspend fun getEnvironmentSetting(argument: suspend GetEnvironmentSettingPlainArgsBuilder.() -> Unit): GetEnvironmentSettingResult {
        val builder = GetEnvironmentSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnvironmentSettingResultToKotlin(getEnvironmentSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get gallery image
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return Represents an image from the Azure Marketplace
     */
    public suspend fun getGalleryImage(argument: GetGalleryImagePlainArgs): GetGalleryImageResult =
        getGalleryImageResultToKotlin(getGalleryImagePlain(argument.toJava()).await())

    /**
     * @see [getGalleryImage].
     * @param expand Specify the $expand query. Example: 'properties($select=author)'
     * @param galleryImageName The name of the gallery Image.
     * @param labAccountName The name of the lab Account.
     * @param resourceGroupName The name of the resource group.
     * @return Represents an image from the Azure Marketplace
     */
    public suspend fun getGalleryImage(
        expand: String? = null,
        galleryImageName: String,
        labAccountName: String,
        resourceGroupName: String,
    ): GetGalleryImageResult {
        val argument = GetGalleryImagePlainArgs(
            expand = expand,
            galleryImageName = galleryImageName,
            labAccountName = labAccountName,
            resourceGroupName = resourceGroupName,
        )
        return getGalleryImageResultToKotlin(getGalleryImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getGalleryImage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetGalleryImagePlainArgs].
     * @return Represents an image from the Azure Marketplace
     */
    public suspend fun getGalleryImage(argument: suspend GetGalleryImagePlainArgsBuilder.() -> Unit): GetGalleryImageResult {
        val builder = GetGalleryImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGalleryImageResultToKotlin(getGalleryImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the virtual machine details
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return Represents the environments details
     */
    public suspend fun getGlobalUserEnvironment(argument: GetGlobalUserEnvironmentPlainArgs): GetGlobalUserEnvironmentResult =
        getGlobalUserEnvironmentResultToKotlin(getGlobalUserEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getGlobalUserEnvironment].
     * @param environmentId The resourceId of the environment
     * @param expand Specify the $expand query. Example: 'properties($expand=environment)'
     * @param userName The name of the user.
     * @return Represents the environments details
     */
    public suspend fun getGlobalUserEnvironment(
        environmentId: String,
        expand: String? = null,
        userName: String,
    ): GetGlobalUserEnvironmentResult {
        val argument = GetGlobalUserEnvironmentPlainArgs(
            environmentId = environmentId,
            expand = expand,
            userName = userName,
        )
        return getGlobalUserEnvironmentResultToKotlin(getGlobalUserEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalUserEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetGlobalUserEnvironmentPlainArgs].
     * @return Represents the environments details
     */
    public suspend fun getGlobalUserEnvironment(argument: suspend GetGlobalUserEnvironmentPlainArgsBuilder.() -> Unit): GetGlobalUserEnvironmentResult {
        val builder = GetGlobalUserEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalUserEnvironmentResultToKotlin(getGlobalUserEnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get batch operation status
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return Status Details of the long running operation for an environment
     */
    public suspend fun getGlobalUserOperationBatchStatus(argument: GetGlobalUserOperationBatchStatusPlainArgs): GetGlobalUserOperationBatchStatusResult =
        getGlobalUserOperationBatchStatusResultToKotlin(getGlobalUserOperationBatchStatusPlain(argument.toJava()).await())

    /**
     * @see [getGlobalUserOperationBatchStatus].
     * @param urls The operation url of long running operation
     * @param userName The name of the user.
     * @return Status Details of the long running operation for an environment
     */
    public suspend fun getGlobalUserOperationBatchStatus(urls: List<String>, userName: String): GetGlobalUserOperationBatchStatusResult {
        val argument = GetGlobalUserOperationBatchStatusPlainArgs(
            urls = urls,
            userName = userName,
        )
        return getGlobalUserOperationBatchStatusResultToKotlin(getGlobalUserOperationBatchStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalUserOperationBatchStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetGlobalUserOperationBatchStatusPlainArgs].
     * @return Status Details of the long running operation for an environment
     */
    public suspend fun getGlobalUserOperationBatchStatus(argument: suspend GetGlobalUserOperationBatchStatusPlainArgsBuilder.() -> Unit): GetGlobalUserOperationBatchStatusResult {
        val builder = GetGlobalUserOperationBatchStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalUserOperationBatchStatusResultToKotlin(getGlobalUserOperationBatchStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the status of long running operation
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return Status Details of the long running operation for an environment
     */
    public suspend fun getGlobalUserOperationStatus(argument: GetGlobalUserOperationStatusPlainArgs): GetGlobalUserOperationStatusResult =
        getGlobalUserOperationStatusResultToKotlin(getGlobalUserOperationStatusPlain(argument.toJava()).await())

    /**
     * @see [getGlobalUserOperationStatus].
     * @param operationUrl The operation url of long running operation
     * @param userName The name of the user.
     * @return Status Details of the long running operation for an environment
     */
    public suspend fun getGlobalUserOperationStatus(operationUrl: String, userName: String): GetGlobalUserOperationStatusResult {
        val argument = GetGlobalUserOperationStatusPlainArgs(
            operationUrl = operationUrl,
            userName = userName,
        )
        return getGlobalUserOperationStatusResultToKotlin(getGlobalUserOperationStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalUserOperationStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetGlobalUserOperationStatusPlainArgs].
     * @return Status Details of the long running operation for an environment
     */
    public suspend fun getGlobalUserOperationStatus(argument: suspend GetGlobalUserOperationStatusPlainArgsBuilder.() -> Unit): GetGlobalUserOperationStatusResult {
        val builder = GetGlobalUserOperationStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalUserOperationStatusResultToKotlin(getGlobalUserOperationStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Get personal preferences for a user
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return Represents the PersonalPreferences for the user
     */
    public suspend fun getGlobalUserPersonalPreferences(argument: GetGlobalUserPersonalPreferencesPlainArgs): GetGlobalUserPersonalPreferencesResult =
        getGlobalUserPersonalPreferencesResultToKotlin(getGlobalUserPersonalPreferencesPlain(argument.toJava()).await())

    /**
     * @see [getGlobalUserPersonalPreferences].
     * @param addRemove Enum indicating if user is adding or removing a favorite lab
     * @param labAccountResourceId Resource Id of the lab account
     * @param labResourceId Resource Id of the lab to add/remove from the favorites list
     * @param userName The name of the user.
     * @return Represents the PersonalPreferences for the user
     */
    public suspend fun getGlobalUserPersonalPreferences(
        addRemove: Either<String, AddRemove>? = null,
        labAccountResourceId: String? = null,
        labResourceId: String? = null,
        userName: String,
    ): GetGlobalUserPersonalPreferencesResult {
        val argument = GetGlobalUserPersonalPreferencesPlainArgs(
            addRemove = addRemove,
            labAccountResourceId = labAccountResourceId,
            labResourceId = labResourceId,
            userName = userName,
        )
        return getGlobalUserPersonalPreferencesResultToKotlin(getGlobalUserPersonalPreferencesPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalUserPersonalPreferences].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetGlobalUserPersonalPreferencesPlainArgs].
     * @return Represents the PersonalPreferences for the user
     */
    public suspend fun getGlobalUserPersonalPreferences(argument: suspend GetGlobalUserPersonalPreferencesPlainArgsBuilder.() -> Unit): GetGlobalUserPersonalPreferencesResult {
        val builder = GetGlobalUserPersonalPreferencesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalUserPersonalPreferencesResultToKotlin(getGlobalUserPersonalPreferencesPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the properties of a lab resource.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2018-10-15, 2023-06-07.
     * @param argument null
     * @return The lab resource.
     */
    public suspend fun getLab(argument: GetLabPlainArgs): GetLabResult =
        getLabResultToKotlin(getLabPlain(argument.toJava()).await())

    /**
     * @see [getLab].
     * @param labName The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The lab resource.
     */
    public suspend fun getLab(labName: String, resourceGroupName: String): GetLabResult {
        val argument = GetLabPlainArgs(
            labName = labName,
            resourceGroupName = resourceGroupName,
        )
        return getLabResultToKotlin(getLabPlain(argument.toJava()).await())
    }

    /**
     * @see [getLab].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetLabPlainArgs].
     * @return The lab resource.
     */
    public suspend fun getLab(argument: suspend GetLabPlainArgsBuilder.() -> Unit): GetLabResult {
        val builder = GetLabPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLabResultToKotlin(getLabPlain(builtArgument.toJava()).await())
    }

    /**
     * Get lab account
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return Represents a lab account.
     */
    public suspend fun getLabAccount(argument: GetLabAccountPlainArgs): GetLabAccountResult =
        getLabAccountResultToKotlin(getLabAccountPlain(argument.toJava()).await())

    /**
     * @see [getLabAccount].
     * @param expand Specify the $expand query. Example: 'properties($expand=sizeConfiguration)'
     * @param labAccountName The name of the lab Account.
     * @param resourceGroupName The name of the resource group.
     * @return Represents a lab account.
     */
    public suspend fun getLabAccount(
        expand: String? = null,
        labAccountName: String,
        resourceGroupName: String,
    ): GetLabAccountResult {
        val argument = GetLabAccountPlainArgs(
            expand = expand,
            labAccountName = labAccountName,
            resourceGroupName = resourceGroupName,
        )
        return getLabAccountResultToKotlin(getLabAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getLabAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetLabAccountPlainArgs].
     * @return Represents a lab account.
     */
    public suspend fun getLabAccount(argument: suspend GetLabAccountPlainArgsBuilder.() -> Unit): GetLabAccountResult {
        val builder = GetLabAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLabAccountResultToKotlin(getLabAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Get regional availability information for each size category configured under a lab account
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return The response model from the GetRegionalAvailability action
     */
    public suspend fun getLabAccountRegionalAvailability(argument: GetLabAccountRegionalAvailabilityPlainArgs): GetLabAccountRegionalAvailabilityResult =
        getLabAccountRegionalAvailabilityResultToKotlin(getLabAccountRegionalAvailabilityPlain(argument.toJava()).await())

    /**
     * @see [getLabAccountRegionalAvailability].
     * @param labAccountName The name of the lab Account.
     * @param resourceGroupName The name of the resource group.
     * @return The response model from the GetRegionalAvailability action
     */
    public suspend fun getLabAccountRegionalAvailability(
        labAccountName: String,
        resourceGroupName: String,
    ): GetLabAccountRegionalAvailabilityResult {
        val argument = GetLabAccountRegionalAvailabilityPlainArgs(
            labAccountName = labAccountName,
            resourceGroupName = resourceGroupName,
        )
        return getLabAccountRegionalAvailabilityResultToKotlin(getLabAccountRegionalAvailabilityPlain(argument.toJava()).await())
    }

    /**
     * @see [getLabAccountRegionalAvailability].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetLabAccountRegionalAvailabilityPlainArgs].
     * @return The response model from the GetRegionalAvailability action
     */
    public suspend fun getLabAccountRegionalAvailability(argument: suspend GetLabAccountRegionalAvailabilityPlainArgsBuilder.() -> Unit): GetLabAccountRegionalAvailabilityResult {
        val builder = GetLabAccountRegionalAvailabilityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLabAccountRegionalAvailabilityResultToKotlin(getLabAccountRegionalAvailabilityPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the properties of a Lab Plan.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2023-06-07.
     * @param argument null
     * @return Lab Plans act as a permission container for creating labs via labs.azure.com. Additionally, they can provide a set of default configurations that will apply at the time of creating a lab, but these defaults can still be overwritten.
     */
    public suspend fun getLabPlan(argument: GetLabPlanPlainArgs): GetLabPlanResult =
        getLabPlanResultToKotlin(getLabPlanPlain(argument.toJava()).await())

    /**
     * @see [getLabPlan].
     * @param labPlanName The name of the lab plan that uniquely identifies it within containing resource group. Used in resource URIs and in UI.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Lab Plans act as a permission container for creating labs via labs.azure.com. Additionally, they can provide a set of default configurations that will apply at the time of creating a lab, but these defaults can still be overwritten.
     */
    public suspend fun getLabPlan(labPlanName: String, resourceGroupName: String): GetLabPlanResult {
        val argument = GetLabPlanPlainArgs(
            labPlanName = labPlanName,
            resourceGroupName = resourceGroupName,
        )
        return getLabPlanResultToKotlin(getLabPlanPlain(argument.toJava()).await())
    }

    /**
     * @see [getLabPlan].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetLabPlanPlainArgs].
     * @return Lab Plans act as a permission container for creating labs via labs.azure.com. Additionally, they can provide a set of default configurations that will apply at the time of creating a lab, but these defaults can still be overwritten.
     */
    public suspend fun getLabPlan(argument: suspend GetLabPlanPlainArgsBuilder.() -> Unit): GetLabPlanResult {
        val builder = GetLabPlanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLabPlanResultToKotlin(getLabPlanPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the properties of a lab Schedule.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2023-06-07.
     * @param argument null
     * @return Schedule for automatically turning virtual machines in a lab on and off at specified times.
     */
    public suspend fun getSchedule(argument: GetSchedulePlainArgs): GetScheduleResult =
        getScheduleResultToKotlin(getSchedulePlain(argument.toJava()).await())

    /**
     * @see [getSchedule].
     * @param labName The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scheduleName The name of the schedule that uniquely identifies it within containing lab. Used in resource URIs.
     * @return Schedule for automatically turning virtual machines in a lab on and off at specified times.
     */
    public suspend fun getSchedule(
        labName: String,
        resourceGroupName: String,
        scheduleName: String,
    ): GetScheduleResult {
        val argument = GetSchedulePlainArgs(
            labName = labName,
            resourceGroupName = resourceGroupName,
            scheduleName = scheduleName,
        )
        return getScheduleResultToKotlin(getSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetSchedulePlainArgs].
     * @return Schedule for automatically turning virtual machines in a lab on and off at specified times.
     */
    public suspend fun getSchedule(argument: suspend GetSchedulePlainArgsBuilder.() -> Unit): GetScheduleResult {
        val builder = GetSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduleResultToKotlin(getSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the properties of a lab user.
     * Azure REST API version: 2022-08-01.
     * Other available API versions: 2018-10-15, 2023-06-07.
     * @param argument null
     * @return User of a lab that can register for and use virtual machines within the lab.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param labName The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param userName The name of the user that uniquely identifies it within containing lab. Used in resource URIs.
     * @return User of a lab that can register for and use virtual machines within the lab.
     */
    public suspend fun getUser(
        labName: String,
        resourceGroupName: String,
        userName: String,
    ): GetUserResult {
        val argument = GetUserPlainArgs(
            labName = labName,
            resourceGroupName = resourceGroupName,
            userName = userName,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return User of a lab that can register for and use virtual machines within the lab.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }

    /**
     * List Environments for the user
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return Represents the list of environments owned by a user
     */
    public suspend fun listGlobalUserEnvironments(argument: ListGlobalUserEnvironmentsPlainArgs): ListGlobalUserEnvironmentsResult =
        listGlobalUserEnvironmentsResultToKotlin(listGlobalUserEnvironmentsPlain(argument.toJava()).await())

    /**
     * @see [listGlobalUserEnvironments].
     * @param labId The resource Id of the lab
     * @param userName The name of the user.
     * @return Represents the list of environments owned by a user
     */
    public suspend fun listGlobalUserEnvironments(labId: String? = null, userName: String): ListGlobalUserEnvironmentsResult {
        val argument = ListGlobalUserEnvironmentsPlainArgs(
            labId = labId,
            userName = userName,
        )
        return listGlobalUserEnvironmentsResultToKotlin(listGlobalUserEnvironmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [listGlobalUserEnvironments].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;ListGlobalUserEnvironmentsPlainArgs].
     * @return Represents the list of environments owned by a user
     */
    public suspend fun listGlobalUserEnvironments(argument: suspend ListGlobalUserEnvironmentsPlainArgsBuilder.() -> Unit): ListGlobalUserEnvironmentsResult {
        val builder = ListGlobalUserEnvironmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGlobalUserEnvironmentsResultToKotlin(listGlobalUserEnvironmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * List labs for the user.
     * Azure REST API version: 2018-10-15.
     * @param argument null
     * @return Lists the labs owned by a user
     */
    public suspend fun listGlobalUserLabs(argument: ListGlobalUserLabsPlainArgs): ListGlobalUserLabsResult =
        listGlobalUserLabsResultToKotlin(listGlobalUserLabsPlain(argument.toJava()).await())

    /**
     * @see [listGlobalUserLabs].
     * @param userName The name of the user.
     * @return Lists the labs owned by a user
     */
    public suspend fun listGlobalUserLabs(userName: String): ListGlobalUserLabsResult {
        val argument = ListGlobalUserLabsPlainArgs(
            userName = userName,
        )
        return listGlobalUserLabsResultToKotlin(listGlobalUserLabsPlain(argument.toJava()).await())
    }

    /**
     * @see [listGlobalUserLabs].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;labservices&#46;kotlin&#46;inputs&#46;ListGlobalUserLabsPlainArgs].
     * @return Lists the labs owned by a user
     */
    public suspend fun listGlobalUserLabs(argument: suspend ListGlobalUserLabsPlainArgsBuilder.() -> Unit): ListGlobalUserLabsResult {
        val builder = ListGlobalUserLabsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGlobalUserLabsResultToKotlin(listGlobalUserLabsPlain(builtArgument.toJava()).await())
    }
}
