@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.ScheduleArgs.builder
import com.pulumi.azurenative.labservices.kotlin.inputs.RecurrencePatternArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.RecurrencePatternArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Schedule for automatically turning virtual machines in a lab on and off at specified times.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-10-01-preview.
 * Other available API versions: 2023-06-07.
 * ## Example Usage
 * ### putSchedule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new AzureNative.LabServices.Schedule("schedule", new()
 *     {
 *         LabName = "testlab",
 *         Notes = "Schedule 1 for students",
 *         RecurrencePattern = new AzureNative.LabServices.Inputs.RecurrencePatternArgs
 *         {
 *             ExpirationDate = "2020-08-14T23:59:59Z",
 *             Frequency = AzureNative.LabServices.RecurrenceFrequency.Daily,
 *             Interval = 2,
 *         },
 *         ResourceGroupName = "testrg123",
 *         ScheduleName = "schedule1",
 *         StartAt = "2020-05-26T12:00:00Z",
 *         StopAt = "2020-05-26T18:00:00Z",
 *         TimeZoneId = "America/Los_Angeles",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/labservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := labservices.NewSchedule(ctx, "schedule", &labservices.ScheduleArgs{
 * 			LabName: pulumi.String("testlab"),
 * 			Notes:   pulumi.String("Schedule 1 for students"),
 * 			RecurrencePattern: &labservices.RecurrencePatternArgs{
 * 				ExpirationDate: pulumi.String("2020-08-14T23:59:59Z"),
 * 				Frequency:      labservices.RecurrenceFrequencyDaily,
 * 				Interval:       pulumi.Int(2),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			ScheduleName:      pulumi.String("schedule1"),
 * 			StartAt:           pulumi.String("2020-05-26T12:00:00Z"),
 * 			StopAt:            pulumi.String("2020-05-26T18:00:00Z"),
 * 			TimeZoneId:        pulumi.String("America/Los_Angeles"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.labservices.Schedule;
 * import com.pulumi.azurenative.labservices.ScheduleArgs;
 * import com.pulumi.azurenative.labservices.inputs.RecurrencePatternArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new Schedule("schedule", ScheduleArgs.builder()
 *             .labName("testlab")
 *             .notes("Schedule 1 for students")
 *             .recurrencePattern(RecurrencePatternArgs.builder()
 *                 .expirationDate("2020-08-14T23:59:59Z")
 *                 .frequency("Daily")
 *                 .interval(2)
 *                 .build())
 *             .resourceGroupName("testrg123")
 *             .scheduleName("schedule1")
 *             .startAt("2020-05-26T12:00:00Z")
 *             .stopAt("2020-05-26T18:00:00Z")
 *             .timeZoneId("America/Los_Angeles")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:Schedule schedule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/schedules/{scheduleName}
 * ```
 * @property labName The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
 * @property notes Notes for this schedule.
 * @property recurrencePattern The recurrence pattern of the scheduled actions.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scheduleName The name of the schedule that uniquely identifies it within containing lab. Used in resource URIs.
 * @property startAt When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
 * @property stopAt When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
 * @property timeZoneId The IANA timezone id for the schedule.
 */
public data class ScheduleArgs(
    public val labName: Output<String>? = null,
    public val notes: Output<String>? = null,
    public val recurrencePattern: Output<RecurrencePatternArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scheduleName: Output<String>? = null,
    public val startAt: Output<String>? = null,
    public val stopAt: Output<String>? = null,
    public val timeZoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.ScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.ScheduleArgs =
        com.pulumi.azurenative.labservices.ScheduleArgs.builder()
            .labName(labName?.applyValue({ args0 -> args0 }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .recurrencePattern(recurrencePattern?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scheduleName(scheduleName?.applyValue({ args0 -> args0 }))
            .startAt(startAt?.applyValue({ args0 -> args0 }))
            .stopAt(stopAt?.applyValue({ args0 -> args0 }))
            .timeZoneId(timeZoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var labName: Output<String>? = null

    private var notes: Output<String>? = null

    private var recurrencePattern: Output<RecurrencePatternArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var scheduleName: Output<String>? = null

    private var startAt: Output<String>? = null

    private var stopAt: Output<String>? = null

    private var timeZoneId: Output<String>? = null

    /**
     * @param value The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     */
    @JvmName("nocemddpnkjyuoav")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value Notes for this schedule.
     */
    @JvmName("oynceqhuoyhxjolm")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value The recurrence pattern of the scheduled actions.
     */
    @JvmName("wvcxhmfmtadgyitr")
    public suspend fun recurrencePattern(`value`: Output<RecurrencePatternArgs>) {
        this.recurrencePattern = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lesdrrkelqfaiupp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the schedule that uniquely identifies it within containing lab. Used in resource URIs.
     */
    @JvmName("psegynkfbkwgcwye")
    public suspend fun scheduleName(`value`: Output<String>) {
        this.scheduleName = value
    }

    /**
     * @param value When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
     */
    @JvmName("swapuxkjhreoahas")
    public suspend fun startAt(`value`: Output<String>) {
        this.startAt = value
    }

    /**
     * @param value When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
     */
    @JvmName("yoqbcynpmwjnkkna")
    public suspend fun stopAt(`value`: Output<String>) {
        this.stopAt = value
    }

    /**
     * @param value The IANA timezone id for the schedule.
     */
    @JvmName("khcpcewifficujom")
    public suspend fun timeZoneId(`value`: Output<String>) {
        this.timeZoneId = value
    }

    /**
     * @param value The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     */
    @JvmName("ifuqabgjgbkwubui")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value Notes for this schedule.
     */
    @JvmName("jignbfgiclywsylr")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value The recurrence pattern of the scheduled actions.
     */
    @JvmName("cwrtqxhgqvfooern")
    public suspend fun recurrencePattern(`value`: RecurrencePatternArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrencePattern = mapped
    }

    /**
     * @param argument The recurrence pattern of the scheduled actions.
     */
    @JvmName("ardhdukrkkrdgtir")
    public suspend fun recurrencePattern(argument: suspend RecurrencePatternArgsBuilder.() -> Unit) {
        val toBeMapped = RecurrencePatternArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recurrencePattern = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xinntxywmustrxep")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the schedule that uniquely identifies it within containing lab. Used in resource URIs.
     */
    @JvmName("upphbqihjkgsgcco")
    public suspend fun scheduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleName = mapped
    }

    /**
     * @param value When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
     */
    @JvmName("wnmnqivlufbglipe")
    public suspend fun startAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startAt = mapped
    }

    /**
     * @param value When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
     */
    @JvmName("wiujayoyyhlmtxqp")
    public suspend fun stopAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stopAt = mapped
    }

    /**
     * @param value The IANA timezone id for the schedule.
     */
    @JvmName("fjejnuhgghobomyq")
    public suspend fun timeZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZoneId = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        labName = labName,
        notes = notes,
        recurrencePattern = recurrencePattern,
        resourceGroupName = resourceGroupName,
        scheduleName = scheduleName,
        startAt = startAt,
        stopAt = stopAt,
        timeZoneId = timeZoneId,
    )
}
