@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes the user's progress in configuring their environment setting
 */
public enum class ConfigurationState(
    public val javaValue: com.pulumi.azurenative.labservices.enums.ConfigurationState,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.enums.ConfigurationState> {
    /**
     * User either hasn't started configuring their template
     * or they haven't started the configuration process.
     */
    NotApplicable(com.pulumi.azurenative.labservices.enums.ConfigurationState.NotApplicable),

    /**
     * User is finished modifying the template.
     */
    Completed(com.pulumi.azurenative.labservices.enums.ConfigurationState.Completed),
    ;

    override fun toJava(): com.pulumi.azurenative.labservices.enums.ConfigurationState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.enums.ConfigurationState): ConfigurationState = ConfigurationState.values().first { it.javaValue == javaType }
    }
}
