@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates what lab virtual machines are created from.
 */
public enum class CreateOption(
    public val javaValue: com.pulumi.azurenative.labservices.enums.CreateOption,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.enums.CreateOption> {
    /**
     * An image is used to create all lab user virtual machines. When this option is set, no template VM will be created.
     */
    Image(com.pulumi.azurenative.labservices.enums.CreateOption.Image),

    /**
     * A template VM will be used to create all lab user virtual machines.
     */
    TemplateVM(com.pulumi.azurenative.labservices.enums.CreateOption.TemplateVM),
    ;

    override fun toJava(): com.pulumi.azurenative.labservices.enums.CreateOption = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.enums.CreateOption): CreateOption = CreateOption.values().first { it.javaValue == javaType }
    }
}
